/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ModelUtil {
    private static List<Pair<ModelResourceLocation, IBakedModel>> registerModels = new LinkedList<Pair<ModelResourceLocation, IBakedModel>>();
    private static List<IModelBakeCallback> modelBakeCallbacks = new LinkedList<IModelBakeCallback>();

    public static void registerCallback(IModelBakeCallback callback) {
        modelBakeCallbacks.add(callback);
    }

    public static void register(ModelResourceLocation location, IBakedModel model) {
        registerModels.add((Pair<ModelResourceLocation, IBakedModel>)Pair.of((Object)location, (Object)model));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Pair<ModelResourceLocation, IBakedModel> pair : registerModels) {
            event.getModelRegistry().func_82595_a(pair.getKey(), pair.getValue());
        }
        for (IModelBakeCallback callback : modelBakeCallbacks) {
            callback.onModelBake((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
        }
    }

    public static interface IModelBakeCallback {
        public void onModelBake(IRegistry<ModelResourceLocation, IBakedModel> var1);
    }
}

