/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.tile.TileDistributor;

public class DistributorRenderer {
    public static final DistributorRenderer INSTANCE = new DistributorRenderer();
    public static final VertexFormat POSITION_COLOR_NORMAL = new VertexFormat(DefaultVertexFormats.field_181706_f).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    public static final Vec3d BLOCK_SIZE = new Vec3d(1.0, 1.0, 1.0);
    public static final int BEAM_LIFETIME = 6;
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private DistributorRenderer() {
    }

    public void onConstruct() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof IDistributorMarkerItem)) continue;
            this.renderMarker(((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack));
        }
        this.renderBeams(event.getPartialTicks());
    }

    public void addBeam(Vec3d source, Vec3d delta) {
        this.beams.add(new BeamInfo(source, delta));
    }

    public void renderMarker(DirectionalGlobalPos globalPos) {
        if (globalPos == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (globalPos.dimension() != mc.field_71441_e.field_73011_w.getDimension()) {
            return;
        }
        int range = 2 * TileDistributor.range + 2;
        BlockPos blockPos = globalPos.blockPos();
        double viewerPosX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double viewerPosY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double viewerPosZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        double distX = viewerPosX - (double)blockPos.func_177958_n() - 0.5;
        double distY = viewerPosY - (double)blockPos.func_177956_o() - 0.5;
        double distZ = viewerPosZ - (double)blockPos.func_177952_p() - 0.5;
        double[] dArray = new double[]{Math.abs(distX), Math.abs(distY), Math.abs(distZ)};
        if (Doubles.max((double[])dArray) > (double)range) {
            return;
        }
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)4.0f);
        GlStateManager.func_179137_b((double)((double)blockPos.func_177958_n() - viewerPosX), (double)((double)blockPos.func_177956_o() - viewerPosY), (double)((double)blockPos.func_177952_p() - viewerPosZ));
        EnumFacing direction = globalPos.direction();
        this.drawMarker(BLOCK_SIZE, direction, 0.0f, 1.0f, 1.0f, 0.5f);
        this.drawMarker(BLOCK_SIZE, null, 0.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    public void renderBeams(float partialTick) {
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + partialTick;
        double viewerPosX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double viewerPosY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double viewerPosZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)3.0f);
        for (BeamInfo beam2 : this.beams) {
            Vec3d source = beam2.source;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(source.field_72450_a - viewerPosX), (double)(source.field_72448_b - viewerPosY), (double)(source.field_72449_c - viewerPosZ));
            this.drawBeam(beam2.delta, 0.0f, 1.0f, 1.0f, beam2.getAlpha(renderTick));
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    public void drawMarker(Vec3d delta, EnumFacing direction, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        buffer.func_181668_a(direction == null ? 1 : 7, DefaultVertexFormats.field_181706_f);
        if (direction == null || direction == EnumFacing.NORTH) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.SOUTH) {
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.WEST) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == EnumFacing.EAST) {
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == EnumFacing.DOWN) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == EnumFacing.UP) {
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        }
        if (direction == null) {
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public void drawBeam(Vec3d delta, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static class BeamInfo {
        private Vec3d source;
        private Vec3d delta;
        private int startTick;

        public BeamInfo(Vec3d source, Vec3d delta) {
            this.source = source;
            this.delta = delta;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= 6;
        }

        public float getAlpha(float renderTick) {
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = diff / 6.0f;
            return 1.0f - factor * factor;
        }
    }
}

