/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client.catwalks;

import dmfmm.catwalks.client.catwalks.CatwalkModel;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CatwalkState {
    TIntSet layers;
    List<CatwalkModel.RailSection> railSections;
    List<CatwalkModel.FloorSection> floorSections;

    private CatwalkState(List<CatwalkModel.RailSection> rail, List<CatwalkModel.FloorSection> floor, TIntSet layers) {
        this.layers = layers;
        this.floorSections = floor;
        this.railSections = rail;
    }

    public CatwalkState(CatwalkModel.RailSection railNW, CatwalkModel.RailSection railNE, CatwalkModel.RailSection railSW, CatwalkModel.RailSection railSE, CatwalkModel.FloorSection floorNW, CatwalkModel.FloorSection floorNE, CatwalkModel.FloorSection floorSW, CatwalkModel.FloorSection floorSE, int ... layers) {
        this(new ArrayList<CatwalkModel.RailSection>(Arrays.asList(railNW, railNE, railSE, railSW)), new ArrayList<CatwalkModel.FloorSection>(Arrays.asList(floorNW, floorNE, floorSE, floorSW)), (TIntSet)new TIntHashSet(layers));
    }

    public boolean hasLayer(int layer) {
        return this.layers.contains(layer);
    }

    public int hashCode() {
        return 31 * (31 * this.railSections.hashCode() + this.floorSections.hashCode()) + this.layers.hashCode();
    }

    public boolean equals(Object o) {
        if (this.hashCode() == o.hashCode()) {
            return true;
        }
        if (!(o instanceof CatwalkState)) {
            return false;
        }
        if (this.railSections != ((CatwalkState)o).railSections) {
            return false;
        }
        if (this.floorSections != ((CatwalkState)o).floorSections) {
            return false;
        }
        return this.layers == ((CatwalkState)o).layers;
    }

    public List<CatwalkModel.RailSection> getRailSections() {
        return this.railSections;
    }

    public List<CatwalkModel.FloorSection> getFloorSections() {
        return this.floorSections;
    }

    public String toString() {
        return "RAIL SECTION: " + this.railSections.get(0).toString() + " " + this.railSections.get(1).toString() + " " + this.railSections.get(2).toString() + " " + this.railSections.get(3).toString() + " FLOOR SECTION: " + this.floorSections.get(0).toString() + " " + this.floorSections.get(1).toString() + " " + this.floorSections.get(2).toString() + " " + this.floorSections.get(3).toString();
    }
}

