/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client.catwalks;

import com.google.common.collect.ImmutableList;
import dmfmm.catwalks.client.catwalks.CatwalkModel;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class CatwalkModelLoader
implements ICustomModelLoader {
    private IResourceManager manager;

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110624_b().equals("catwalks") && modelLocation.func_110623_a().endsWith("!!catwalks:catwalk");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new CatwalkModelWrapper(modelLocation.func_110624_b(), modelLocation.func_110623_a().replace("!!catwalks:catwalk", "").replace("models/", ""), "");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
    }

    class CatwalkModelWrapper
    implements IModel {
        ResourceLocation item_r1;
        ResourceLocation rails_r1;
        ResourceLocation floor_r1;
        IModel item;
        IModel rails;
        IModel floor;

        public CatwalkModelWrapper(String domain, String path, String postfix) {
            this.item_r1 = new ResourceLocation(domain, path + "/item" + postfix);
            this.rails_r1 = new ResourceLocation(domain, path + "/rails" + postfix);
            this.floor_r1 = new ResourceLocation(domain, path + "/floor" + postfix);
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.item_r1, (Object)this.floor_r1, (Object)this.rails_r1);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (this.item == null || this.rails == null || this.floor == null) {
                this.item = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.item_r1);
                this.rails = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.rails_r1);
                this.floor = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.floor_r1);
            }
            return new CatwalkModel(this.item.bake(state, format, bakedTextureGetter), this.rails.bake(state, format, bakedTextureGetter), this.floor.bake(state, format, bakedTextureGetter));
        }
    }
}

