/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client.catwalks;

import com.google.common.collect.ImmutableList;
import dmfmm.catwalks.block.CatwalkBlock;
import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.client.catwalks.ModelSlicer;
import dmfmm.catwalks.utils.CatwalkConfigs;
import dmfmm.catwalks.utils.CatwalkMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CatwalkModel
implements IBakedModel {
    IBakedModel item;
    IBakedModel rails;
    IBakedModel floor;
    static Map<String, Map<CatwalkState, List<BakedQuad>>> cache2 = new HashMap<String, Map<CatwalkState, List<BakedQuad>>>();

    public CatwalkModel(IBakedModel item, IBakedModel rails, IBakedModel floor) {
        this.item = item;
        this.floor = floor;
        this.rails = rails;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        CatwalkState cw = null;
        String material = "classic";
        if (state != null) {
            material = ((CatwalkMaterial)((Object)state.func_177229_b(CatwalkBlock.MATERIAL))).func_176610_l().toLowerCase();
        }
        if (state instanceof IExtendedBlockState) {
            cw = (CatwalkState)((IExtendedBlockState)state).getValue(CatwalkBlock.CATWALK_STATE);
        }
        if (cw == null) {
            cw = new CatwalkState(RailSection.OUTER, RailSection.OUTER, RailSection.OUTER, RailSection.OUTER, FloorSection.OUTER, FloorSection.OUTER, FloorSection.OUTER, FloorSection.OUTER, 0);
        }
        if (cache2.containsKey(material) && !CatwalkConfigs.supportOptifine) {
            List<BakedQuad> quads;
            Map<CatwalkState, List<BakedQuad>> map = cache2.get(material);
            if (map.containsKey(cw) && !(quads = map.get(cw)).isEmpty()) {
                return map.get(cw);
            }
        } else {
            HashMap m = new HashMap();
            cache2.put(material, m);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        List railQuads = this.rails.func_188616_a(state, side, rand);
        List floorQuads = this.floor.func_188616_a(state, side, rand);
        CatwalkState finalCw = cw;
        Function<BakedQuad, Boolean> filter = q -> !q.func_178212_b() || finalCw.hasLayer(q.func_178211_c());
        for (int it = 0; it < 4; ++it) {
            Vec3d offset = new Vec3d(it == 1 || it == 2 ? 0.5 : 0.0, -1.0, it > 1 ? 0.5 : 0.0);
            ModelSlicer.sliceInto((ImmutableList.Builder<BakedQuad>)builder, railQuads, (AxisAlignedBB)cw.railSections.get(it).boundingBoxes.get(it), offset, filter);
            if (cw.floorSections.get(it) == null) continue;
            ModelSlicer.sliceInto((ImmutableList.Builder<BakedQuad>)builder, floorQuads, (AxisAlignedBB)cw.floorSections.get(it).boundingBoxes.get(it), offset, filter);
        }
        cache2.get(material).put(cw, (List<BakedQuad>)builder.build());
        return cache2.get(material).get(cw);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.item.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public static enum FloorSection {
        MIDDLE(0, 0),
        Z_EDGE(1, 0),
        X_EDGE(0, 1),
        INNER(1, 1),
        OUTER(2, 2);

        private int x;
        private int z;
        private ArrayList<AxisAlignedBB> boundingBoxes;

        private FloorSection(int x, int z) {
            this.x = x - 1;
            this.z = z - 1;
            AxisAlignedBB model = new AxisAlignedBB((double)this.x, -1.0, (double)this.z, (double)this.x + 0.5, 2.0, (double)this.z + 0.5);
            this.boundingBoxes = new ArrayList();
            this.boundingBoxes.addAll(Arrays.asList(model, model.func_72317_d(0.5, 0.0, 0.0), model.func_72317_d(0.5, 0.0, 0.5), model.func_72317_d(0.0, 0.0, 0.5)));
        }
    }

    public static enum RailSection {
        MIDDLE(0, 0),
        Z_EDGE(1, 0),
        Z_END(2, 0),
        X_EDGE(0, 1),
        X_END(0, 2),
        INNER(1, 1),
        OUTER(2, 2);

        private int x;
        private int z;
        private ArrayList<AxisAlignedBB> boundingBoxes;

        private RailSection(int x, int z) {
            this.x = x - 1;
            this.z = z - 1;
            AxisAlignedBB model = new AxisAlignedBB((double)this.x, -1.0, (double)this.z, (double)this.x + 0.5, 2.0, (double)this.z + 0.5);
            this.boundingBoxes = new ArrayList();
            this.boundingBoxes.addAll(Arrays.asList(model, model.func_72317_d(0.5, 0.0, 0.0), model.func_72317_d(0.5, 0.0, 0.5), model.func_72317_d(0.0, 0.0, 0.5)));
        }
    }
}

