/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client.catwalks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dmfmm.catwalks.client.catwalks.CatwalkLegacyModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class CatwalkLegacyModelLoader
implements ICustomModelLoader {
    private IResourceManager manager;

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110624_b().equals("catwalks") && modelLocation.func_110623_a().endsWith("!!catwalks:catwalk_legacy");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new CatwalkLegacyModelWrapper(modelLocation.func_110624_b(), modelLocation.func_110623_a().replace("!!catwalks:catwalk_legacy", "").replace("models/", ""), "");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
    }

    class CatwalkLegacyModelWrapper
    implements IModel {
        ResourceLocation bottom;
        ResourceLocation bottom_corner;
        ResourceLocation bottom_edge;
        ResourceLocation corner_outer;
        ResourceLocation right_merge;
        ResourceLocation left_merge;
        ResourceLocation corner_inner;
        ResourceLocation left_connect;
        ResourceLocation right_connect;
        IModel modelbottom;
        IModel modelBottomCorner;
        IModel modelBottomEdge;
        IModel modelOuterCorner;
        IModel modelLeftMerge;
        IModel modelRightMerge;
        IModel modelInner;
        IModel modelLeftConnect;
        IModel modelRightConnect;
        boolean match;
        String path;

        public CatwalkLegacyModelWrapper(String domain, String path, String postfix) {
            this.bottom = new ResourceLocation(domain, path + "/bottom" + postfix);
            this.bottom_corner = new ResourceLocation(domain, path + "/bottom_corner" + postfix);
            this.bottom_edge = new ResourceLocation(domain, path + "/bottom_edge" + postfix);
            this.corner_outer = new ResourceLocation(domain, path + "/corner_outer" + postfix);
            this.right_merge = new ResourceLocation(domain, path + "/right_merge" + postfix);
            this.left_merge = new ResourceLocation(domain, path + "/left_merge" + postfix);
            this.corner_inner = new ResourceLocation(domain, path + "/corner_inner" + postfix);
            this.left_connect = new ResourceLocation(domain, path + "/left_connect" + postfix);
            this.right_connect = new ResourceLocation(domain, path + "/right_connect" + postfix);
            this.path = path;
        }

        public IModel process(ImmutableMap<String, String> customData) {
            String floorStr = (String)customData.get((Object)"matchFloor");
            this.match = Boolean.valueOf(floorStr);
            return this;
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.bottom, (Object)this.bottom_corner, (Object)this.bottom_edge, (Object)this.corner_outer, (Object)this.right_merge, (Object)this.left_merge, (Object)this.corner_inner, (Object)this.left_connect, (Object)this.right_connect);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (this.modelbottom == null || this.modelBottomCorner == null || this.modelBottomEdge == null) {
                this.modelbottom = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.bottom);
                this.modelBottomCorner = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.bottom_corner);
                this.modelBottomEdge = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.bottom_edge);
                this.modelOuterCorner = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.corner_outer);
                this.modelLeftMerge = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.left_merge);
                this.modelRightMerge = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.right_merge);
                this.modelInner = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.corner_inner);
                this.modelLeftConnect = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.left_connect);
                this.modelRightConnect = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.right_connect);
            }
            HashMap<String, IModel> models = new HashMap<String, IModel>();
            models.put("bottom", this.modelbottom);
            models.put("bottom_corner", this.modelBottomCorner);
            models.put("bottom_edge", this.modelBottomEdge);
            models.put("corner_outer", this.modelOuterCorner);
            models.put("left_merge", this.modelLeftMerge);
            models.put("right_merge", this.modelRightMerge);
            models.put("corner_inner", this.modelInner);
            models.put("left_connect", this.modelLeftConnect);
            models.put("right_connect", this.modelRightConnect);
            return new CatwalkLegacyModel(this.match, this.path.substring(this.path.lastIndexOf("/") + 1), models, format, bakedTextureGetter);
        }
    }
}

