/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client;

import dmfmm.catwalks.block.CatwalkBlock;
import dmfmm.catwalks.client.catwalks.CatwalkModel;
import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.item.BlowtorchItem;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RedOverlayEvent {
    @SubscribeEvent
    public void renderCatwalkEmptyFaces(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = mc.field_71439_g;
        ItemStack heldItem = p.func_184586_b(EnumHand.MAIN_HAND);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof BlowtorchItem && p.func_70093_af()) {
            RedOverlayEvent.renderFullCatwalkBlocks(evt, mc);
        }
    }

    private static void renderFullCatwalkBlocks(RenderWorldLastEvent evt, Minecraft mc) {
        EntityPlayerSP p = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)true);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockPos c = p.func_180425_c().func_177982_a(dx, dy, dz);
                    IBlockState state = world.func_180495_p(c);
                    Block block = state.func_177230_c();
                    if (!(block instanceof CatwalkBlock)) continue;
                    BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                    IBlockState actualState = block.func_176221_a(state, (IBlockAccess)world, c);
                    IBakedModel model = dispatcher.func_184389_a(actualState);
                    IBlockState state1 = RedOverlayEvent.computeMissingSides((World)world, actualState, c);
                    dispatcher.func_175019_b().func_178267_a((IBlockAccess)world, model, state1, c, buffer, false);
                }
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179121_F();
    }

    private static IBlockState computeMissingSides(World world, IBlockState state, BlockPos pos) {
        IBlockState bS = ((CatwalkBlock)state.func_177230_c()).getExtendedState(state, (IBlockAccess)world, pos);
        if (bS instanceof IExtendedBlockState) {
            IExtendedBlockState extBS = (IExtendedBlockState)bS;
            CatwalkState catwalkState = (CatwalkState)extBS.getValue(CatwalkBlock.CATWALK_STATE);
            CatwalkState state1 = new CatwalkState(RedOverlayEvent.getOpposite(catwalkState.getRailSections().get(0)), RedOverlayEvent.getOpposite(catwalkState.getRailSections().get(1)), RedOverlayEvent.getOpposite(catwalkState.getRailSections().get(3)), RedOverlayEvent.getOpposite(catwalkState.getRailSections().get(2)), catwalkState.getFloorSections().get(0) == null ? CatwalkModel.FloorSection.OUTER : null, catwalkState.getFloorSections().get(1) == null ? CatwalkModel.FloorSection.OUTER : null, catwalkState.getFloorSections().get(2) == null ? CatwalkModel.FloorSection.OUTER : null, catwalkState.getFloorSections().get(3) == null ? CatwalkModel.FloorSection.OUTER : null, new int[0]);
            return extBS.withProperty(CatwalkBlock.CATWALK_STATE, (Object)state1);
        }
        return state;
    }

    private static CatwalkModel.RailSection getOpposite(CatwalkModel.RailSection current) {
        switch (current) {
            case X_EDGE: 
            case X_END: {
                return CatwalkModel.RailSection.Z_EDGE;
            }
            case MIDDLE: {
                return CatwalkModel.RailSection.OUTER;
            }
            case Z_END: 
            case Z_EDGE: {
                return CatwalkModel.RailSection.X_EDGE;
            }
            case INNER: {
                return CatwalkModel.RailSection.OUTER;
            }
        }
        return CatwalkModel.RailSection.MIDDLE;
    }

    private static class RedWrapper
    implements IBakedModel {
        IBakedModel delegate;

        public RedWrapper(IBakedModel model) {
            this.delegate = model;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            List<BakedQuad> bbq = this.delegate.func_188616_a(state, side, rand);
            bbq = bbq.stream().map(q -> {
                UnpackedBakedQuad.Builder b = new UnpackedBakedQuad.Builder(q.getFormat());
                q.pipe((IVertexConsumer)new VertexTransformer((IVertexConsumer)b){

                    public void put(int element, float ... data) {
                        if (this.getVertexFormat().func_177348_c(element).func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                            if (data.length >= 3) {
                                data[0] = 1.0f;
                                data[1] = 0.0f;
                                data[2] = 0.0f;
                                super.put(element, data);
                            } else {
                                super.put(element, data);
                            }
                        } else {
                            super.put(element, data);
                        }
                    }
                });
                UnpackedBakedQuad ubq = b.build();
                return new BakedQuad(ubq.func_178209_a(), ubq.func_178211_c(), ubq.func_178210_d(), ubq.func_187508_a(), ubq.shouldApplyDiffuseLighting(), ubq.getFormat());
            }).collect(Collectors.toList());
            return bbq;
        }

        public boolean func_177555_b() {
            return this.delegate.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.delegate.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.delegate.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.delegate.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return this.delegate.func_188617_f();
        }
    }
}

