/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.block;

import dmfmm.catwalks.block.GenericBlock;
import dmfmm.catwalks.registry.ItemRegistry;
import dmfmm.catwalks.tileentity.IConnectTile;
import dmfmm.catwalks.tileentity.LadderTile;
import dmfmm.catwalks.utils.LadderBlockHitboxes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class LadderBlock
extends GenericBlock
implements ITileEntityProvider {
    public static final IUnlistedProperty<Boolean> HAS_CAGE = new IUnlistedProperty<Boolean>(){

        public String getName() {
            return "caged";
        }

        public boolean isValid(Boolean value) {
            return true;
        }

        public Class<Boolean> getType() {
            return Boolean.class;
        }

        public String valueToString(Boolean value) {
            return value != false ? "true" : "false";
        }
    };
    public static final IUnlistedProperty<Boolean> CONNECTED = new IUnlistedProperty<Boolean>(){

        public String getName() {
            return "connectible";
        }

        public boolean isValid(Boolean value) {
            return true;
        }

        public Class<Boolean> getType() {
            return Boolean.class;
        }

        public String valueToString(Boolean value) {
            return value != false ? "true" : "false";
        }
    };
    public static final IUnlistedProperty<LadderState> STATE = new IUnlistedProperty<LadderState>(){

        public String getName() {
            return "ladderstate";
        }

        public boolean isValid(LadderState value) {
            return true;
        }

        public Class<LadderState> getType() {
            return LadderState.class;
        }

        public String valueToString(LadderState value) {
            return value.toString().toLowerCase();
        }
    };
    public static final IUnlistedProperty<EnumFacing> FACING = new IUnlistedProperty<EnumFacing>(){

        public String getName() {
            return "facing";
        }

        public boolean isValid(EnumFacing value) {
            return true;
        }

        public Class<EnumFacing> getType() {
            return EnumFacing.class;
        }

        public String valueToString(EnumFacing value) {
            return value.toString().toLowerCase();
        }
    };

    public LadderBlock() {
        super("ladder");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() != ItemRegistry.BLOW_TORCH) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof LadderTile)) {
            return false;
        }
        EnumFacing tileFacing = ((LadderTile)tileEntity).getFacing();
        if (facing == tileFacing && world.func_175625_s(pos.func_177972_a(facing)) instanceof IConnectTile) {
            ((LadderTile)tileEntity).setHasConnection(!((LadderTile)tileEntity).doesHaveConnection());
        } else if (facing == tileFacing.func_176734_d()) {
            ((LadderTile)tileEntity).setHasCage(!((LadderTile)tileEntity).doesHaveCage());
        }
        world.func_184138_a(pos, state, state, 2);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LadderTile) {
            EnumFacing f = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)entity).func_176734_d();
            if (f == EnumFacing.UP || f == EnumFacing.DOWN) {
                f = EnumFacing.NORTH;
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                    f = ((LadderTile)world.func_175625_s(pos.func_177977_b())).getFacing();
                }
            }
            ((LadderTile)te).setFacing(f);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            boolean matchup = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            boolean matchdown = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
            TileEntity te = world.func_175625_s(pos);
            IExtendedBlockState theState = (IExtendedBlockState)state;
            if (te instanceof LadderTile) {
                theState = theState.withProperty(HAS_CAGE, (Object)((LadderTile)te).doesHaveCage());
                theState = theState.withProperty(FACING, (Object)((LadderTile)te).getFacing());
            } else {
                theState = theState.withProperty(HAS_CAGE, (Object)true);
                theState = theState.withProperty(FACING, (Object)EnumFacing.NORTH);
            }
            if (matchup && matchdown) {
                theState = theState.withProperty(STATE, (Object)LadderState.MIDDLE);
            } else if (matchup) {
                theState = theState.withProperty(STATE, (Object)LadderState.BOTTOM);
                TileEntity tes = world.func_175625_s(pos.func_177972_a(EnumFacing.NORTH.func_176734_d()));
                theState = tes instanceof IConnectTile && !(tes instanceof LadderTile) ? theState.withProperty(CONNECTED, (Object)true) : theState.withProperty(CONNECTED, (Object)false);
            } else {
                theState = theState.withProperty(STATE, (Object)LadderState.TOP);
                theState = te instanceof LadderTile ? theState.withProperty(CONNECTED, (Object)((LadderTile)te).doesHaveConnection()) : theState.withProperty(CONNECTED, (Object)false);
            }
            return theState;
        }
        return state;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        IExtendedBlockState estate = (IExtendedBlockState)this.getExtendedState(state, world, pos);
        Double[] ladder = LadderBlockHitboxes.getLadderBox((EnumFacing)estate.getValue(FACING));
        AxisAlignedBB bb = new AxisAlignedBB((double)pos.func_177958_n() + ladder[0], (double)pos.func_177956_o() + ladder[1], (double)pos.func_177952_p() + ladder[2], (double)pos.func_177958_n() + ladder[3], (double)pos.func_177956_o() + ladder[4], (double)pos.func_177952_p() + ladder[5]);
        AxisAlignedBB ba = entity.func_174813_aQ();
        return bb.field_72340_a <= ba.field_72336_d && bb.field_72336_d >= ba.field_72340_a && bb.field_72338_b < ba.field_72337_e && bb.field_72337_e > ba.field_72338_b && bb.field_72339_c <= ba.field_72334_f && bb.field_72334_f >= ba.field_72339_c;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IExtendedBlockState estate = (IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos);
        Double[][] hit = LadderBlockHitboxes.getBoxAdditions((EnumFacing)estate.getValue(FACING));
        AxisAlignedBB bb = new AxisAlignedBB((double)pos.func_177958_n() + hit[1][0], (double)pos.func_177956_o() + hit[1][1], (double)pos.func_177952_p() + hit[1][2], (double)pos.func_177958_n() + hit[1][3], (double)pos.func_177956_o() + hit[1][4], (double)pos.func_177952_p() + hit[1][5]);
        if (estate.getValue(STATE) == LadderState.BOTTOM || estate.getValue(STATE) == LadderState.TOP && estate.getUnlistedNames().contains(HAS_CAGE) && ((Boolean)estate.getValue(HAS_CAGE)).booleanValue() || estate.getValue(STATE) == LadderState.MIDDLE && estate.getUnlistedNames().contains(HAS_CAGE) && ((Boolean)estate.getValue(HAS_CAGE)).booleanValue()) {
            if (bb.func_72326_a(entityBox)) {
                collidingBoxes.add(bb);
            }
            if ((bb = new AxisAlignedBB((double)pos.func_177958_n() + hit[2][0], (double)pos.func_177956_o() + hit[2][1], (double)pos.func_177952_p() + hit[2][2], (double)pos.func_177958_n() + hit[2][3], (double)pos.func_177956_o() + hit[2][4], (double)pos.func_177952_p() + hit[2][5])).func_72326_a(entityBox)) {
                collidingBoxes.add(bb);
            }
        }
        if ((estate.getValue(STATE) == LadderState.BOTTOM || estate.getValue(STATE) == LadderState.MIDDLE || estate.getValue(STATE) == LadderState.TOP && estate.getUnlistedNames().contains(STATE) && !((Boolean)estate.getValue(CONNECTED)).booleanValue()) && (bb = new AxisAlignedBB((double)pos.func_177958_n() + hit[0][0], (double)pos.func_177956_o() + hit[0][1], (double)pos.func_177952_p() + hit[0][2], (double)pos.func_177958_n() + hit[0][3], (double)pos.func_177956_o() + hit[0][4], (double)pos.func_177952_p() + hit[0][5])).func_72326_a(entityBox)) {
            collidingBoxes.add(bb);
        }
        if ((estate.getValue(STATE) == LadderState.TOP && estate.getUnlistedNames().contains(HAS_CAGE) && ((Boolean)estate.getValue(HAS_CAGE)).booleanValue() || estate.getValue(STATE) == LadderState.MIDDLE && estate.getUnlistedNames().contains(HAS_CAGE) && ((Boolean)estate.getValue(HAS_CAGE)).booleanValue()) && (bb = new AxisAlignedBB((double)pos.func_177958_n() + hit[3][0], (double)pos.func_177956_o() + hit[3][1], (double)pos.func_177952_p() + hit[3][2], (double)pos.func_177958_n() + hit[3][3], (double)pos.func_177956_o() + hit[3][4], (double)pos.func_177952_p() + hit[3][5])).func_72326_a(entityBox)) {
            collidingBoxes.add(bb);
        }
        if (estate.getValue(STATE) == LadderState.BOTTOM && (bb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 0.2, (double)(pos.func_177952_p() + 1))).func_72326_a(entityBox)) {
            collidingBoxes.add(bb);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{CONNECTED}).add(new IUnlistedProperty[]{HAS_CAGE}).add(new IUnlistedProperty[]{STATE}).add(new IUnlistedProperty[]{FACING}).build();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new LadderTile();
    }

    public static enum LadderState implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

