/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.utils;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.item.upgrades.UpgradeOpenSecurity;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.Conditions;
import com.bymarcin.openglasses.utils.OpenGlassesHostClient;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

public class GlassesInstance {
    private ItemStack stack;
    private Conditions conditions = new Conditions();
    private UUID glassesUUID = null;
    public boolean thermalVisionActive = false;
    public boolean openSecurityOverlayActive = false;
    public double energyStored = 0.0;
    private HashMap<UUID, HostClient> hosts = new HashMap();

    public GlassesInstance(ItemStack glassesStack) {
        ItemStack itemStack = this.stack = OpenGlasses.isGlassesStack(glassesStack) ? glassesStack : ItemStack.field_190927_a;
        if (!this.get().func_190926_b()) {
            NBTTagCompound nbt = this.get().func_77978_p();
            this.conditions.bufferSensors(this.get());
            this.glassesUUID = GlassesNBT.getUniqueId(this.get());
            this.thermalVisionActive = nbt.func_74764_b("thermalActive") && nbt.func_74767_n("thermalActive");
            this.energyStored = OpenGlassesItem.getEnergyStored(this.get());
            for (NBTTagCompound tag : OpenGlassesHostsNBT.getHostsFromNBT(this.stack)) {
                this.hosts.put(tag.func_186857_a("host"), new HostClient(tag));
            }
        } else {
            this.conditions = new Conditions();
            this.thermalVisionActive = false;
            this.energyStored = 0.0;
        }
    }

    public void refresh() {
        this.refreshConditions();
        this.energyStored = OpenGlassesItem.getEnergyStored(this.get());
        this.openSecurityOverlayActive = OpenGlasses.opensecurity && this.conditions.hasOpenSecurity && UpgradeOpenSecurity.getMode(this.get());
    }

    public ItemStack get() {
        return this.stack;
    }

    public void refreshConditions() {
        if (!this.get().func_190926_b()) {
            this.conditions.getConditionStates((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    public HashMap<UUID, HostClient> getHosts() {
        return this.hosts;
    }

    public UUID getUniqueId() {
        return this.glassesUUID;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public HostClient getHost(UUID hostUUID) {
        return this.hosts.get(hostUUID);
    }

    public static class HostClient {
        public UUID uuid = null;
        public boolean renderWorld = true;
        public boolean renderOverlay = true;
        public boolean sendOverlayEvents = true;
        public boolean sendWorldEvents = true;
        public UUID ownerUUID;
        public String ownerName = "";
        public Vec3d renderResolution = new Vec3d(0.0, 0.0, 0.0);

        public HostClient(UUID host, EntityPlayer owner) {
            this.uuid = host;
            this.ownerUUID = owner.func_110124_au();
            this.ownerName = owner.getDisplayNameString();
        }

        HostClient(NBTTagCompound nbt) {
            this.updateFromNBT(nbt);
        }

        void updateFromNBT(NBTTagCompound nbt) {
            this.uuid = nbt.func_186857_a("host");
            this.ownerName = nbt.func_74779_i("user");
            this.ownerUUID = nbt.func_186857_a("ownerUUID");
            this.renderWorld = !nbt.func_74764_b("noWorld");
            this.renderOverlay = !nbt.func_74764_b("noOverlay");
            this.sendOverlayEvents = !nbt.func_74764_b("noOverlayEvents");
            boolean bl = this.sendWorldEvents = !nbt.func_74764_b("noWorldEvents");
            if (nbt.func_74764_b("resolution")) {
                NBTTagCompound resolutionTag = nbt.func_74775_l("resolution");
                this.renderResolution = new Vec3d(resolutionTag.func_74769_h("x"), resolutionTag.func_74769_h("y"), 0.0);
            }
        }

        public OpenGlassesHostClient getHost() {
            return OCClientSurface.instance().getHost(this.uuid);
        }
    }
}

