/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.gui.GlassesGui;
import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.OCClientSurface;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TerminalStatusPacket
extends Packet<TerminalStatusPacket, IMessage> {
    private TerminalEvent terminalEvent;
    public float x;
    public float y;
    private UUID hostUUID;

    public TerminalStatusPacket(TerminalEvent status, UUID hostUUID) {
        this.terminalEvent = status;
        this.hostUUID = hostUUID;
    }

    public TerminalStatusPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.terminalEvent = TerminalEvent.values()[this.readInt()];
        this.hostUUID = this.readUUID();
        switch (this.terminalEvent) {
            case SET_RENDER_RESOLUTION: {
                this.x = this.readFloat();
                this.y = this.readFloat();
            }
        }
    }

    @Override
    protected void write() throws IOException {
        this.writeInt(this.terminalEvent.ordinal());
        this.writeUUID(this.hostUUID);
        switch (this.terminalEvent) {
            case SET_RENDER_RESOLUTION: {
                this.writeFloat(this.x);
                this.writeFloat(this.y);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IMessage executeOnClient() {
        switch (this.terminalEvent) {
            case SET_RENDER_RESOLUTION: {
                if (this.x > 0.0f && this.y > 0.0f) {
                    OCClientSurface.instance().setRenderResolution(new Vec3d((double)this.x, (double)this.y, 0.0), this.hostUUID);
                } else {
                    OCClientSurface.instance().setRenderResolution(null, this.hostUUID);
                }
                return null;
            }
            case ASYNC_SCREEN_SIZES: {
                OCClientSurface.instance().sendResolution();
                return null;
            }
            case NOTIFICATION: {
                ItemStack glassesStack = OpenGlasses.getGlassesStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                if (!(glassesStack.func_190926_b() || glassesStack.func_77978_p().func_74764_b("nopopups") || Minecraft.func_71410_x().field_71462_r instanceof GlassesGui)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GlassesGui(true));
                }
                return null;
            }
            case GLASSES_UNEQUIPPED: {
                OCClientSurface.instance().equipmentChanged(ItemStack.field_190927_a);
                return null;
            }
            case GLASSES_EQUIPPED: {
                OCClientSurface.instance().equipmentChanged(OpenGlasses.getGlassesStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
                return null;
            }
        }
        return null;
    }

    @Override
    protected IMessage executeOnServer(EntityPlayerMP player) {
        return null;
    }

    public static enum TerminalEvent {
        SYNC_SCREEN_SIZE,
        ASYNC_SCREEN_SIZES,
        SET_RENDER_RESOLUTION,
        NOTIFICATION,
        GLASSES_EQUIPPED,
        GLASSES_UNEQUIPPED;

    }
}

