/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.upgrades;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.event.minecraft.client.ClientKeyboardEvents;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeDaylightDetector;
import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeNightvision;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.surface.OCServerSurface;
import com.bymarcin.openglasses.utils.PlayerStatsOC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpgradeThermalVision
extends UpgradeItem {
    @Override
    public ItemStack install(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74767_n("thermalvision")) {
            tag.func_74757_a("thermalvision", true);
        }
        return stack;
    }

    @Override
    public int getUpgradeExperienceCost() {
        return 420;
    }

    @Override
    public int getEnergyUsage() {
        return 10;
    }

    @Override
    public int getEnergyUsageCurrent(ItemStack stack) {
        return UpgradeThermalVision.getMode(stack) ? this.getEnergyUsage() : 0;
    }

    @Override
    public boolean isInstalled(ItemStack stack) {
        return UpgradeThermalVision.hasUpgrade(stack);
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return false;
    }

    public static boolean hasUpgrade(ItemStack stack) {
        return UpgradeGeolyzer.hasUpgrade(stack) && UpgradeNightvision.hasUpgrade(stack) && UpgradeDaylightDetector.hasUpgrade(stack);
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (UpgradeThermalVision.hasUpgrade(stack)) {
            tooltip.add("thermalvision: available (active: " + UpgradeThermalVision.getMode(stack) + ")");
        } else {
            tooltip.add("thermalvision not available");
            if (!UpgradeGeolyzer.hasUpgrade(stack)) {
                tooltip.add("\u00a78requires geolyzer\u00a77");
            }
            if (!UpgradeNightvision.hasUpgrade(stack)) {
                tooltip.add("\u00a78requires nightvision\u00a77");
            }
            if (!UpgradeDaylightDetector.hasUpgrade(stack)) {
                tooltip.add("\u00a78requires lightsensor\u00a77");
            }
        }
        return tooltip;
    }

    private static void setMode(ItemStack glassesStack, boolean active) {
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return;
        }
        glassesStack.func_77978_p().func_74757_a("thermalActive", active);
    }

    private static boolean shouldEnableInfrared(EntityPlayer player, ItemStack glassesStack) {
        if (!UpgradeThermalVision.hasUpgrade(glassesStack)) {
            return false;
        }
        if (OpenGlassesItem.getEnergyStored(glassesStack) == 0.0) {
            return false;
        }
        return UpgradeThermalVision.getMode(glassesStack);
    }

    private static boolean getMode(ItemStack glassesStack) {
        return glassesStack.func_77978_p().func_74767_n("thermalActive");
    }

    public static void toggleMode(EntityPlayer player) {
        ItemStack stack = OpenGlasses.getGlassesStack(player);
        if (OpenGlasses.isGlassesStack(stack)) {
            UpgradeThermalVision.setMode(stack, !UpgradeThermalVision.getMode(stack));
            player.func_146105_b((ITextComponent)new TextComponentString("thermal vision active: " + UpgradeThermalVision.getMode(stack)), true);
        }
    }

    @Override
    public void updateServer(EntityPlayer player, ItemStack glassesStack) {
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return;
        }
        PlayerStatsOC stats = OCServerSurface.getStats((EntityPlayerMP)player);
        boolean wasActive = stats.thermalActive;
        if (UpgradeThermalVision.shouldEnableInfrared(player, glassesStack)) {
            UpgradeThermalVision.setMode(glassesStack, true);
            if (!wasActive) {
                OpenGlassesItem.upgradeUpkeepCost(glassesStack);
                GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
            }
            stats.thermalActive = true;
        } else if (stats.thermalActive) {
            UpgradeThermalVision.setMode(glassesStack, false);
            if (wasActive) {
                OpenGlassesItem.upgradeUpkeepCost(glassesStack);
                GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
            }
            stats.thermalActive = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput() {
        if (!ClientKeyboardEvents.thermalvisionModeKey.func_151468_f()) {
            return;
        }
        if (!UpgradeThermalVision.hasUpgrade(OCClientSurface.glasses.get())) {
            return;
        }
        NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(null, GlassesEventPacket.EventType.TOGGLE_INFRARED));
    }
}

