/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.core;

import betterwithmods.module.gameplay.Gameplay;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.LoliReflector;
import zone.rong.loliasm.api.LoliStringPool;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.core.LoliLoadingPlugin;
import zone.rong.loliasm.patches.BakedQuadFactoryPatch;
import zone.rong.loliasm.patches.BakedQuadPatch;
import zone.rong.loliasm.patches.BakedQuadRetexturedPatch;
import zone.rong.loliasm.patches.UnpackedBakedQuadPatch;

public class LoliTransformer
implements IClassTransformer {
    public static boolean isOptifineInstalled;
    public static boolean isSodiumPortInstalled;
    public static boolean squashBakedQuads;
    Multimap<String, Function<byte[], byte[]>> transformations;

    public LoliTransformer() {
        LoliLogger.instance.info("The lolis are now preparing to bytecode manipulate your game.");
        isOptifineInstalled = LoliReflector.doesClassExist("optifine.OptiFineForgeTweaker");
        isSodiumPortInstalled = LoliReflector.doesClassExist("me.jellysquid.mods.sodium.client.SodiumMixinTweaker");
        if (squashBakedQuads) {
            if (isOptifineInstalled) {
                squashBakedQuads = false;
                LoliLogger.instance.info("Optifine is installed. BakedQuads won't be squashed as it is incompatible with OptiFine.");
            } else if (isSodiumPortInstalled) {
                squashBakedQuads = false;
                LoliLogger.instance.info("A sodium port is installed. BakedQuads won't be squashed as it is incompatible with Sodium.");
            }
        }
        this.transformations = MultimapBuilder.hashKeys((int)30).arrayListValues(1).build();
        if (LoliLoadingPlugin.isClient) {
            if (squashBakedQuads) {
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuad", BakedQuadPatch::rewriteBakedQuad);
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuadRetextured", BakedQuadRetexturedPatch::patchBakedQuadRetextured);
                this.addTransformation("net.minecraftforge.client.model.pipeline.UnpackedBakedQuad", UnpackedBakedQuadPatch::rewriteUnpackedBakedQuad);
                this.addTransformation("net.minecraftforge.client.model.pipeline.UnpackedBakedQuad$Builder", UnpackedBakedQuadPatch::rewriteUnpackedBakedQuad$Builder);
                this.addTransformation("zone.rong.loliasm.bakedquad.BakedQuadFactory", BakedQuadFactoryPatch::patchCreateMethod);
                for (String classThatExtendBakedQuad : LoliConfig.instance.classesThatExtendBakedQuad) {
                    if (classThatExtendBakedQuad.trim().isEmpty()) continue;
                    this.addTransformation(classThatExtendBakedQuad, this::extendSupportingBakedQuadInstead);
                }
            } else if (LoliConfig.instance.vertexDataCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuad", this::canonicalizeVertexData);
            }
            if (LoliConfig.instance.modelConditionCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ICondition", this::canonicalBoolConditions);
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionOr", bytes -> this.canonicalPredicatedConditions((byte[])bytes, true));
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionAnd", bytes -> this.canonicalPredicatedConditions((byte[])bytes, false));
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue", this::canonicalPropertyValueConditions);
            }
            if (LoliConfig.instance.resourceLocationCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.ModelResourceLocation", this::canonicalizeResourceLocationStrings);
            }
            if (LoliConfig.instance.stripInstancedRandomFromSoundEventAccessor) {
                this.addTransformation("net.minecraft.client.audio.SoundEventAccessor", this::removeInstancedRandom);
            }
            if (LoliConfig.instance.optimizeRegistries) {
                this.addTransformation("net.minecraft.client.audio.SoundRegistry", this::removeDupeMapFromSoundRegistry);
                this.addTransformation("net.minecraftforge.client.model.ModelLoader", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.block.statemap.StateMapperBase", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.BlockModelShapes", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.block.statemap.BlockStateMapper", this::optimizeDataStructures);
            }
            if (LoliConfig.instance.optimizeSomeRendering) {
                this.addTransformation("net.minecraft.client.renderer.RenderGlobal", bytes -> this.fixEnumFacingValuesClone((byte[])bytes, LoliLoadingPlugin.isDeobf ? "setupTerrain" : "func_174970_a"));
            }
            if (LoliConfig.instance.stripUnnecessaryLocalsInRenderHelper) {
                this.addTransformation("net.minecraft.client.renderer.RenderHelper", this::stripLocalsInEnableStandardItemLighting);
            }
            if (LoliConfig.instance.spriteNameCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.texture.TextureAtlasSprite", this::canonicalizeSpriteNames);
            }
            if (LoliConfig.instance.removeExcessiveGCCalls) {
                this.addTransformation("net.minecraft.client.Minecraft", this::removeExcessiveGCCalls);
            }
            if (LoliConfig.instance.smoothDimensionChange) {
                this.addTransformation("net.minecraft.client.network.NetHandlerPlayClient", this::smoothDimensionChange);
            }
            if (LoliConfig.instance.fixMC88176) {
                this.addTransformation("net.minecraft.client.renderer.RenderGlobal", this::disappearingEntitiesRenderGlobalFix);
                this.addTransformation("net.minecraft.client.renderer.chunk.RenderChunk", this::disappearingEntitiesRenderChunkFix);
            }
        }
        if (LoliConfig.instance.resourceLocationCanonicalization) {
            this.addTransformation("net.minecraft.util.ResourceLocation", this::canonicalizeResourceLocationStrings);
        }
        if (LoliConfig.instance.optimizeRegistries) {
            this.addTransformation("net.minecraft.util.registry.RegistrySimple", this::removeValuesArrayFromRegistrySimple);
        }
        if (LoliConfig.instance.nbtTagStringBackingStringCanonicalization) {
            this.addTransformation("net.minecraft.nbt.NBTTagString", this::nbtTagStringRevamp);
        }
        if (LoliConfig.instance.packageStringCanonicalization) {
            this.addTransformation("net.minecraftforge.fml.common.discovery.ModCandidate", this::removePackageField);
        }
        if (LoliConfig.instance.asmDataStringCanonicalization) {
            this.addTransformation("net.minecraftforge.fml.common.discovery.ASMDataTable$ASMData", this::deduplicateASMDataStrings);
        }
        if (LoliConfig.instance.stripNearUselessItemStackFields) {
            this.addTransformation("net.minecraft.item.ItemStack", this::stripItemStackFields);
        }
        if (LoliConfig.instance.optimizeFurnaceRecipeStore) {
            this.addTransformation("net.minecraft.item.crafting.FurnaceRecipes", this::improveFurnaceRecipes);
        }
        if (LoliConfig.instance.fixAmuletHolderCapability) {
            this.addTransformation("hellfirepvp.astralsorcery.common.enchantment.amulet.PlayerAmuletHandler", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "attachAmuletItemCapability"));
        }
        if (LoliConfig.instance.labelCanonicalization) {
            this.addTransformation("mezz.jei.suffixtree.Edge", this::deduplicateEdgeLabels);
        }
        if (LoliConfig.instance.bwmBlastingOilOptimization) {
            this.addTransformation("betterwithmods.event.BlastingOilEvent", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "onPlayerTakeDamage", "onHitGround"));
            this.addTransformation("betterwithmods.common.items.ItemMaterial", this::injectBlastingOilEntityItemUpdate);
        }
        if (LoliConfig.instance.optimizeQMDBeamRenderer) {
            this.addTransformation("lach_01298.qmd.render.entity.BeamRenderer", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "renderBeamEffects"));
        }
        if (LoliConfig.instance.fixTFCFallingBlockFalseStartingTEPos) {
            this.addTransformation("net.dries007.tfc.objects.entity.EntityFallingBlockTFC", this::fixTFCFallingBlock);
        }
        if (LoliConfig.instance.delayItemStackCapabilityInit) {
            this.addTransformation("net.minecraft.item.ItemStack", this::delayItemStackCapabilityInit);
        }
        if (LoliConfig.instance.fixMC30845) {
            this.addTransformation("net.minecraft.client.renderer.EntityRenderer", this::fixMC30845);
        }
        if (LoliConfig.instance.fixMC31681) {
            this.addTransformation("net.minecraft.client.renderer.EntityRenderer", this::fixMC31681);
        }
        this.addTransformation("net.minecraft.nbt.NBTTagCompound", bytes -> this.nbtTagCompound$replaceDefaultHashMap((byte[])bytes, LoliConfig.instance.optimizeNBTTagCompoundBackingMap, LoliConfig.instance.nbtBackingMapStringCanonicalization));
    }

    public void addTransformation(String key, Function<byte[], byte[]> value) {
        LoliLogger.instance.info("Adding class {} to the transformation queue", (Object)key);
        this.transformations.put((Object)key, value);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Collection getBytes = this.transformations.get((Object)transformedName);
        if (getBytes != null) {
            byte[] transformedByteArray = bytes;
            for (Function func : getBytes) {
                transformedByteArray = (byte[])func.apply(transformedByteArray);
            }
            return transformedByteArray;
        }
        return bytes;
    }

    private byte[] extendSupportingBakedQuadInstead(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (node.superName.equals("net/minecraft/client/renderer/block/model/BakedQuad")) {
            node.superName = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
        }
        ObjectOpenHashSet fieldsToLookOutFor = new ObjectOpenHashSet((Object[])new String[]{"face", "applyDiffuseLighting", "tintIndex"});
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode instruction : method.instructions) {
                if (method.name.equals("<init>") && instruction instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)instruction;
                    if (methodNode.getOpcode() != 183 || !methodNode.owner.equals("net/minecraft/client/renderer/block/model/BakedQuad")) continue;
                    methodNode.owner = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
                    continue;
                }
                if (!(instruction instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.owner.equals("net/minecraft/client/renderer/block/model/BakedQuad") || !fieldsToLookOutFor.contains(fieldNode.name)) continue;
                fieldNode.owner = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalizeResourceLocationStrings(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("(I[Ljava/lang/String;)V")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof MethodInsnNode) || instruction.getOpcode() != 182 || !((MethodInsnNode)instruction).name.equals("toLowerCase")) continue;
                LoliLogger.instance.info("Injecting calls in {}{} to canonicalize strings", (Object)node.name, (Object)method.name);
                iter.previous();
                iter.previous();
                iter.remove();
                iter.next();
                iter.set(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "lowerCaseAndCanonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalBoolConditions(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<clinit>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof TypeInsnNode) || instruction.getOpcode() != 187) continue;
                boolean bool = ((TypeInsnNode)instruction).desc.endsWith("$1");
                LoliLogger.instance.info("Canonizing {} IConditions", (Object)(bool ? "TRUE" : "FALSE"));
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.remove();
                iter.add(new FieldInsnNode(178, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", bool ? "TRUE" : "FALSE", "Lnet/minecraft/client/renderer/block/model/multipart/ICondition;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalPredicatedConditions(byte[] bytes, boolean or) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String getPredicate = LoliLoadingPlugin.isDeobf ? "getPredicate" : "func_188118_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(getPredicate)) continue;
            String conditions = LoliLoadingPlugin.isDeobf ? "conditions" : (or ? "field_188127_c" : "field_188121_c");
            LoliLogger.instance.info("Transforming {}::getPredicate to canonicalize different IConditions", (Object)node.name);
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, conditions, "Ljava/lang/Iterable;"));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", or ? "orCache" : "andCache", "(Ljava/lang/Iterable;Lnet/minecraft/block/state/BlockStateContainer;)Lcom/google/common/base/Predicate;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalPropertyValueConditions(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String getPredicate = LoliLoadingPlugin.isDeobf ? "getPredicate" : "func_188118_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(getPredicate)) continue;
            LoliLogger.instance.info("Transforming {}::getPredicate to canonicalize different PropertyValueConditions", (Object)node.name);
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, LoliLoadingPlugin.isDeobf ? "key" : "field_188125_d", "Ljava/lang/String;"));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, LoliLoadingPlugin.isDeobf ? "value" : "field_188126_e", "Ljava/lang/String;"));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, node.name, LoliLoadingPlugin.isDeobf ? "SPLITTER" : "field_188124_c", "Lcom/google/common/base/Splitter;"));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", "propertyValueCache", "(Lnet/minecraft/block/state/BlockStateContainer;Ljava/lang/String;Ljava/lang/String;Lcom/google/common/base/Splitter;)Lcom/google/common/base/Predicate;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            method.localVariables.clear();
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] cacheMultipartBakedModels(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String makeMultipartModel = LoliLoadingPlugin.isDeobf ? "makeMultipartModel" : "func_188647_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(makeMultipartModel)) continue;
            LoliLogger.instance.info("Transforming {}::makeMultipartModel", (Object)node.name);
            String builderSelectors = LoliLoadingPlugin.isDeobf ? "builderSelectors" : "field_188649_a";
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, builderSelectors, "Ljava/util/Map;"));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/MultipartBakedModelCache", "makeMultipartModel", "(Ljava/util/Map;)Lnet/minecraft/client/renderer/block/model/MultipartBakedModel;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeValuesArrayFromRegistrySimple(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String values = LoliLoadingPlugin.isDeobf ? "values" : "field_186802_b";
        node.fields.removeIf(f -> f.name.equals(values));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeDupeMapFromSoundRegistry(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String soundRegistry = LoliLoadingPlugin.isDeobf ? "soundRegistry" : "field_148764_a";
        node.fields.removeIf(f -> f.name.equals(soundRegistry));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] improveFurnaceRecipes(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            boolean isExperienceList = false;
            LoliLogger.instance.info("Improving FurnaceRecipes. Lookups are now a lot faster.");
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInstruction = (MethodInsnNode)instruction;
                if (!methodInstruction.owner.equals("com/google/common/collect/Maps")) continue;
                iter.remove();
                if (!isExperienceList) {
                    iter.add(new TypeInsnNode(187, "it/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap"));
                    iter.add(new InsnNode(89));
                    iter.add(new FieldInsnNode(178, "zone/rong/loliasm/api/HashingStrategies", "FURNACE_INPUT_HASH", "Lit/unimi/dsi/fastutil/Hash$Strategy;"));
                    iter.add(new MethodInsnNode(183, "it/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap", "<init>", "(Lit/unimi/dsi/fastutil/Hash$Strategy;)V", false));
                    if (LoliConfig.instance.furnaceExperienceVanilla) break block0;
                    isExperienceList = true;
                    continue;
                }
                iter.add(new TypeInsnNode(187, "it/unimi/dsi/fastutil/objects/Object2FloatOpenCustomHashMap"));
                iter.add(new InsnNode(89));
                iter.add(new FieldInsnNode(178, "zone/rong/loliasm/api/HashingStrategies", "FURNACE_INPUT_HASH", "Lit/unimi/dsi/fastutil/Hash$Strategy;"));
                iter.add(new MethodInsnNode(183, "it/unimi/dsi/fastutil/objects/Object2FloatOpenCustomHashMap", "<init>", "(Lit/unimi/dsi/fastutil/Hash$Strategy;)V", false));
                iter.next();
                iter.add(new VarInsnNode(25, 0));
                iter.add(new FieldInsnNode(180, "net/minecraft/item/crafting/FurnaceRecipes", LoliLoadingPlugin.isDeobf ? "experienceList" : "field_77605_c", "Ljava/util/Map;"));
                iter.add(new TypeInsnNode(192, "it/unimi/dsi/fastutil/objects/Object2FloatFunction"));
                iter.add(new LdcInsnNode((Object)Float.valueOf(0.0f)));
                iter.add(new MethodInsnNode(185, "it/unimi/dsi/fastutil/objects/Object2FloatFunction", "defaultReturnValue", "(F)V", true));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeInstancedRandom(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.fields.removeIf(f -> f.desc.equals("Ljava/util/Random;"));
        for (MethodNode method : node.methods) {
            AbstractInsnNode instruction;
            ListIterator iter;
            if (method.name.equals("<init>")) {
                iter = method.instructions.iterator();
                while (iter.hasNext()) {
                    instruction = (AbstractInsnNode)iter.next();
                    if (!(instruction instanceof TypeInsnNode)) continue;
                    TypeInsnNode newNode = (TypeInsnNode)instruction;
                    if (!newNode.desc.equals("java/util/Random")) continue;
                    iter.previous();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                }
                continue;
            }
            if (!method.name.equals(LoliLoadingPlugin.isDeobf ? "cloneEntry" : "func_148720_g")) continue;
            iter = method.instructions.iterator();
            while (iter.hasNext()) {
                instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180 || !((FieldInsnNode)instruction).desc.equals("Ljava/util/Random;")) continue;
                iter.previous();
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.remove();
                iter.add(new MethodInsnNode(184, "java/util/concurrent/ThreadLocalRandom", "current", "()Ljava/util/concurrent/ThreadLocalRandom;", false));
                iter.add(new IntInsnNode(21, 1));
                iter.add(new MethodInsnNode(182, "java/util/concurrent/ThreadLocalRandom", "nextInt", "(I)I", false));
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] nbtTagCompound$replaceDefaultHashMap(byte[] bytes, boolean optimizeMap, boolean canonicalizeString) {
        if (!optimizeMap && !canonicalizeString) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 184) continue;
                iter.set(new TypeInsnNode(187, canonicalizeString ? "zone/rong/loliasm/api/datastructures/canonical/AutoCanonizingArrayMap" : "it/unimi/dsi/fastutil/objects/Object2ObjectArrayMap"));
                iter.add(new InsnNode(89));
                iter.add(new MethodInsnNode(183, canonicalizeString ? "zone/rong/loliasm/api/datastructures/canonical/AutoCanonizingArrayMap" : "it/unimi/dsi/fastutil/objects/Object2ObjectArrayMap", "<init>", "()V", false));
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixEnumFacingValuesClone(byte[] bytes, String methodMatch) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals(methodMatch)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
                if (!methodInsnNode.name.equals("values") || !methodInsnNode.desc.equals("()[Lnet/minecraft/util/EnumFacing;")) continue;
                LoliLogger.instance.info("Transforming EnumFacing::values() to EnumFacing::VALUES in {}", (Object)node.name);
                iter.set(new FieldInsnNode(178, "net/minecraft/util/EnumFacing", LoliLoadingPlugin.isDeobf ? "VALUES" : "field_82609_l", "[Lnet/minecraft/util/EnumFacing;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removePackageField(byte[] bytes) {
        try {
            Map packages = (Map)LoliReflector.getField(ClassLoader.class, "packages").get(Launch.classLoader);
            Set packageStrings = packages.keySet();
            packageStrings.forEach(LoliStringPool::canonicalize);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.fields.stream().filter(f -> f.name.equals("packages")).findFirst().ifPresent(f -> {
            f.desc = "Ljava/util/Set;";
            f.signature = "Ljava/util/Set<Ljava/lang/String;>;";
        });
        block2: for (MethodNode method : node.methods) {
            FieldInsnNode fieldNode;
            AbstractInsnNode instruction;
            ListIterator iter;
            if (method.name.equals("<init>") && method.desc.equals("(Ljava/io/File;Ljava/io/File;Lnet/minecraftforge/fml/common/discovery/ContainerType;ZZ)V")) {
                iter = method.instructions.iterator();
                while (iter.hasNext()) {
                    instruction = (AbstractInsnNode)iter.next();
                    if (instruction.getOpcode() != 181) continue;
                    fieldNode = (FieldInsnNode)instruction;
                    if (!fieldNode.name.equals("packages")) continue;
                    fieldNode.desc = "Ljava/util/Set;";
                    iter.previous();
                    iter.previous();
                    iter.set(new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "createHashSet", "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", false));
                    continue block2;
                }
                continue;
            }
            if (method.name.equals("addClassEntry")) {
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "foundClasses", "Ljava/util/Set;"));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "packages", "Ljava/util/Set;"));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "table", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;"));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "modCandidate$override$addClassEntry", "(Lnet/minecraftforge/fml/common/discovery/ModCandidate;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Lnet/minecraftforge/fml/common/discovery/ASMDataTable;)V", false));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                continue;
            }
            if (!method.name.equals("getContainedPackages")) continue;
            iter = method.instructions.iterator();
            while (iter.hasNext()) {
                instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180) continue;
                fieldNode = (FieldInsnNode)instruction;
                fieldNode.desc = "Ljava/util/Set;";
                iter.add(new MethodInsnNode(184, "com/google/common/collect/Lists", "newArrayList", "(Ljava/lang/Iterable;)Ljava/util/ArrayList;", false));
                continue block2;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] nbtTagStringRevamp(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("(Ljava/lang/String;)V")) continue;
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction.getOpcode() != 181) continue;
                method.instructions.insertBefore(instruction, (AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "nbtTagString$override$ctor", "(Ljava/lang/String;)Ljava/lang/String;", false));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripSubscribeEventAnnotation(byte[] bytes, String ... methodNames) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            for (String methodName : methodNames) {
                List annotations;
                if (!method.name.equals(methodName) || (annotations = method.visibleAnnotations) == null) continue;
                annotations.removeIf(a -> a.desc.equals("Lnet/minecraftforge/fml/common/eventhandler/SubscribeEvent;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripItemStackFields(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String[] fields = new String[]{!LoliLoadingPlugin.isDeobf ? "field_82843_f" : "itemFrame", !LoliLoadingPlugin.isDeobf ? "field_179552_h" : "canDestroyCacheBlock", !LoliLoadingPlugin.isDeobf ? "field_179553_i" : "canDestroyCacheResult", !LoliLoadingPlugin.isDeobf ? "field_179550_j" : "canPlaceOnCacheBlock", !LoliLoadingPlugin.isDeobf ? "field_179551_k" : "canPlaceOnCacheResult"};
        node.fields.removeIf(f -> ArrayUtils.contains((Object[])fields, (Object)f.name));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripLocalsInEnableStandardItemLighting(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals(LoliLoadingPlugin.isDeobf ? "enableStandardItemLighting" : "func_74519_b")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 56) continue;
                iter.remove();
                iter.previous();
                iter.remove();
                method.localVariables = null;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] deduplicateEdgeLabels(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") && !method.name.equals("setLabel")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181 || !((FieldInsnNode)instruction).name.equals("label")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "canonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] deduplicateASMDataStrings(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.name.equals("annotationName") && !fieldNode.name.equals("className")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "asmData$redirect$CtorStringsToIntern", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalizeSpriteNames(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.desc.equals("Ljava/lang/String")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "canonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] injectBlastingOilEntityItemUpdate(byte[] bytes) {
        if (!Gameplay.disableBlastingOilEvents) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            ClassWriter writer = new ClassWriter(2);
            node.accept((ClassVisitor)writer);
            MethodVisitor methodVisitor = writer.visitMethod(1, "onEntityItemUpdate", "(Lnet/minecraft/entity/item/EntityItem;)Z", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(184, "zone/rong/loliasm/common/modfixes/betterwithmods/BWMBlastingOilOptimization", "inject$ItemMaterial$onEntityItemUpdate", "(Lnet/minecraft/entity/item/EntityItem;)Z", false);
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(2, 2);
            methodVisitor.visitEnd();
            writer.visitEnd();
            return writer.toByteArray();
        }
        return bytes;
    }

    private byte[] canonicalizeVertexData(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("([IILnet/minecraft/util/EnumFacing;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;ZLnet/minecraft/client/renderer/vertex/VertexFormat;)V")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.desc.equals("[I")) continue;
                iter.previous();
                iter.add(new VarInsnNode(25, 0));
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/bakedquad/LoliVertexDataPool", "canonicalize", "([ILnet/minecraft/client/renderer/block/model/BakedQuad;)[I", false));
                method.maxStack = 3;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] optimizeDataStructures(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode methodNode = (MethodInsnNode)instruction;
                switch (methodNode.name) {
                    case "newIdentityHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createReferenceMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Reference2ObjectOpenHashMap;";
                        break;
                    }
                    case "newLinkedHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createLinkedMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;";
                        break;
                    }
                    case "newHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createHashMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;";
                        break;
                    }
                    case "newHashSet": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createHashSet";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;";
                        break;
                    }
                    case "newIdentityHashSet": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createReferenceSet";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/ReferenceOpenHashSet;";
                    }
                }
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixTFCFallingBlock(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("(Lnet/minecraft/world/World;DDDLnet/minecraft/block/state/IBlockState;)V")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 187 || !((TypeInsnNode)instruction).desc.equals("net/minecraft/util/math/BlockPos")) continue;
                iter.next();
                iter.next();
                iter.set(new VarInsnNode(24, 2));
                iter.add(new VarInsnNode(24, 4));
                iter.add(new VarInsnNode(24, 6));
                MethodInsnNode currentInstruction = (MethodInsnNode)iter.next();
                currentInstruction.desc = "(DDD)V";
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] delayItemStackCapabilityInit(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String writeToNBT = !LoliLoadingPlugin.isDeobf ? "func_77955_b" : "writeToNBT";
        String isEmpty = !LoliLoadingPlugin.isDeobf ? "func_82582_d" : "isEmpty";
        String setTag = !LoliLoadingPlugin.isDeobf ? "func_74782_a" : "setTag";
        LabelNode branchLabel = new LabelNode(new Label());
        LabelNode returnLabel = null;
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals(writeToNBT)) continue;
            ListIterator iter = method.instructions.iterator();
            boolean found = false;
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!found && instruction.getOpcode() == 180) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
                    if (!fieldInsnNode.name.equals("capabilities")) continue;
                    JumpInsnNode jumpInsnNode = (JumpInsnNode)iter.next();
                    returnLabel = jumpInsnNode.label;
                    jumpInsnNode.label = branchLabel;
                    found = true;
                    continue;
                }
                if (!found || instruction != returnLabel) continue;
                InsnList instructions = new InsnList();
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, returnLabel));
                instructions.add((AbstractInsnNode)branchLabel);
                instructions.add((AbstractInsnNode)new FrameNode(3, -1, null, -1, null));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/item/ItemStack", "capNBT", "Lnet/minecraft/nbt/NBTTagCompound;"));
                instructions.add((AbstractInsnNode)new JumpInsnNode(198, returnLabel));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/item/ItemStack", "capNBT", "Lnet/minecraft/nbt/NBTTagCompound;"));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", isEmpty, "()Z", false));
                instructions.add((AbstractInsnNode)new JumpInsnNode(154, returnLabel));
                LabelNode branchNode = new LabelNode(new Label());
                instructions.add((AbstractInsnNode)branchNode);
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add((AbstractInsnNode)new LdcInsnNode((Object)"ForgeCaps"));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/item/ItemStack", "capNBT", "Lnet/minecraft/nbt/NBTTagCompound;"));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", setTag, "(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", false));
                method.instructions.insertBefore(instruction, instructions);
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeExcessiveGCCalls(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String loadWorld = !LoliLoadingPlugin.isDeobf ? "func_71353_a" : "loadWorld";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(loadWorld)) continue;
            ListIterator iter = method.instructions.iterator();
            block1: while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode invokeStatic = (MethodInsnNode)instruction;
                if (!invokeStatic.owner.equals("java/lang/System") || !invokeStatic.name.equals("gc")) continue;
                LabelNode l56 = (LabelNode)iter.next();
                iter.previous();
                iter.previous();
                iter.remove();
                iter.previous();
                iter.remove();
                iter.previous();
                iter.remove();
                LabelNode l54 = (LabelNode)iter.previous();
                iter.remove();
                while (iter.hasPrevious()) {
                    AbstractInsnNode previousInstruction = (AbstractInsnNode)iter.previous();
                    if (previousInstruction.getOpcode() != 167) continue;
                    JumpInsnNode gotoNode = (JumpInsnNode)previousInstruction;
                    if (gotoNode.label != l54) continue;
                    gotoNode.label = l56;
                    continue block1;
                }
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] smoothDimensionChange(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String handleJoinGame = !LoliLoadingPlugin.isDeobf ? "func_147282_a" : "handleJoinGame";
        String handleRespawn = !LoliLoadingPlugin.isDeobf ? "func_147280_a" : "handleRespawn";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(handleJoinGame) && !method.name.equals(handleRespawn)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 183) continue;
                MethodInsnNode invokeSpecial = (MethodInsnNode)instruction;
                if (!invokeSpecial.owner.equals("net/minecraft/client/gui/GuiDownloadTerrain")) continue;
                iter.remove();
                iter.previous();
                iter.remove();
                iter.previous();
                iter.set(new InsnNode(1));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixMC30845(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String orientCamera = !LoliLoadingPlugin.isDeobf ? "func_78467_g" : "orientCamera";
        String rayTraceBlocksOld = !LoliLoadingPlugin.isDeobf ? "func_72933_a" : "rayTraceBlocks";
        String rayTraceBlocksNew = !LoliLoadingPlugin.isDeobf ? "func_147447_a" : "rayTraceBlocks";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(orientCamera)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 182) continue;
                MethodInsnNode invokeVirtual = (MethodInsnNode)instruction;
                if (!invokeVirtual.name.equals(rayTraceBlocksOld)) continue;
                iter.set(new InsnNode(3));
                iter.add(new InsnNode(4));
                iter.add(new InsnNode(4));
                iter.add(new MethodInsnNode(invokeVirtual.getOpcode(), invokeVirtual.owner, rayTraceBlocksNew, "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;", false));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixMC31681(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String updateRenderer = !LoliLoadingPlugin.isDeobf ? "func_78464_a" : "updateRenderer";
        String renderDistanceChunks = !LoliLoadingPlugin.isDeobf ? "field_151451_c" : "renderDistanceChunks";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(updateRenderer)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180) continue;
                FieldInsnNode getField = (FieldInsnNode)instruction;
                if (!getField.name.equals(renderDistanceChunks)) continue;
                iter.remove();
                iter.previous();
                iter.remove();
                iter.previous();
                iter.remove();
                iter.previous();
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.set(new InsnNode(12));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] disappearingEntitiesRenderGlobalFix(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String setupTerrain = !LoliLoadingPlugin.isDeobf ? "func_174970_a" : "setupTerrain";
        String renderChunkBoundingBox = !LoliLoadingPlugin.isDeobf ? "field_178591_c" : "boundingBox";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(setupTerrain)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180) continue;
                FieldInsnNode getField = (FieldInsnNode)instruction;
                if (!getField.name.equals(renderChunkBoundingBox)) continue;
                iter.set(new MethodInsnNode(184, "zone/rong/loliasm/patches/RenderGlobalPatch", "getCorrectBoundingBox", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)Lnet/minecraft/util/math/AxisAlignedBB;", false));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] disappearingEntitiesRenderChunkFix(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String renderChunkBoundingBox = !LoliLoadingPlugin.isDeobf ? "field_178591_c" : "boundingBox";
        for (MethodNode method : node.methods) {
            if (!method.name.equals("isBoundingBoxInFrustum")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180) continue;
                FieldInsnNode getField = (FieldInsnNode)instruction;
                if (!getField.name.equals(renderChunkBoundingBox)) continue;
                iter.set(new MethodInsnNode(184, "zone/rong/loliasm/patches/RenderGlobalPatch", "getCorrectBoundingBox", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)Lnet/minecraft/util/math/AxisAlignedBB;", false));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        squashBakedQuads = LoliConfig.instance.squashBakedQuads;
    }
}

