/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.singletonevents.mixins;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import zone.rong.loliasm.common.singletonevents.IRefreshEvent;

@Mixin(value={FMLCommonHandler.class}, remap=false)
public abstract class FMLCommonHandlerMixin {
    @Unique
    private static final TickEvent.ClientTickEvent START_CLIENT_TICK_EVENT = new TickEvent.ClientTickEvent(TickEvent.Phase.START);
    @Unique
    private static final TickEvent.ClientTickEvent END_CLIENT_TICK_EVENT = new TickEvent.ClientTickEvent(TickEvent.Phase.END);
    @Unique
    private static final TickEvent.ServerTickEvent START_SERVER_TICK_EVENT = new TickEvent.ServerTickEvent(TickEvent.Phase.START);
    @Unique
    private static final TickEvent.ServerTickEvent END_SERVER_TICK_EVENT = new TickEvent.ServerTickEvent(TickEvent.Phase.END);
    @Unique
    private static final TickEvent.WorldTickEvent START_WORLD_TICK_EVENT = new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.START, null);
    @Unique
    private static final TickEvent.WorldTickEvent END_WORLD_TICK_EVENT = new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, null);
    @Unique
    private static final IRefreshEvent START_WORLD_TICK_EVENT_CASTED = (IRefreshEvent)START_WORLD_TICK_EVENT;
    @Unique
    private static final IRefreshEvent END_WORLD_TICK_EVENT_CASTED = (IRefreshEvent)END_WORLD_TICK_EVENT;
    @Unique
    private static final TickEvent.PlayerTickEvent CLIENT_START_PLAYER_TICK_EVENT = new TickEvent.PlayerTickEvent(TickEvent.Phase.START, null);
    @Unique
    private static final TickEvent.PlayerTickEvent CLIENT_END_PLAYER_TICK_EVENT = new TickEvent.PlayerTickEvent(TickEvent.Phase.END, null);
    @Unique
    private static final TickEvent.PlayerTickEvent SERVER_START_PLAYER_TICK_EVENT = new TickEvent.PlayerTickEvent(TickEvent.Phase.START, null);
    @Unique
    private static final TickEvent.PlayerTickEvent SERVER_END_PLAYER_TICK_EVENT = new TickEvent.PlayerTickEvent(TickEvent.Phase.END, null);
    @Unique
    private static final IRefreshEvent CLIENT_START_PLAYER_TICK_EVENT_CASTED = (IRefreshEvent)CLIENT_START_PLAYER_TICK_EVENT;
    @Unique
    private static final IRefreshEvent CLIENT_END_PLAYER_TICK_EVENT_CASTED = (IRefreshEvent)CLIENT_END_PLAYER_TICK_EVENT;
    @Unique
    private static final IRefreshEvent SERVER_START_PLAYER_TICK_EVENT_CASTED = ((IRefreshEvent)SERVER_START_PLAYER_TICK_EVENT).setTickSide(Side.SERVER);
    @Unique
    private static final IRefreshEvent SERVER_END_PLAYER_TICK_EVENT_CASTED = ((IRefreshEvent)SERVER_END_PLAYER_TICK_EVENT).setTickSide(Side.SERVER);
    @Unique
    private static final TickEvent.RenderTickEvent START_RENDER_TICK_EVENT = new TickEvent.RenderTickEvent(TickEvent.Phase.START, 0.0f);
    @Unique
    private static final TickEvent.RenderTickEvent END_RENDER_TICK_EVENT = new TickEvent.RenderTickEvent(TickEvent.Phase.END, 0.0f);
    @Unique
    private static final IRefreshEvent START_RENDER_TICK_EVENT_CASTED = (IRefreshEvent)START_RENDER_TICK_EVENT;

    @Shadow
    @Deprecated
    public abstract EventBus bus();

    @Overwrite
    public void onPostServerTick() {
        this.bus().post((Event)END_SERVER_TICK_EVENT);
    }

    @Overwrite
    public void onPostWorldTick(World world) {
        END_WORLD_TICK_EVENT_CASTED.beforeWorldTick(world);
        this.bus().post((Event)END_WORLD_TICK_EVENT);
        END_WORLD_TICK_EVENT_CASTED.afterWorldTick();
    }

    @Overwrite
    public void onPreServerTick() {
        this.bus().post((Event)START_SERVER_TICK_EVENT);
    }

    @Overwrite
    public void onPreWorldTick(World world) {
        START_WORLD_TICK_EVENT_CASTED.beforeWorldTick(world);
        this.bus().post((Event)START_WORLD_TICK_EVENT);
        START_WORLD_TICK_EVENT_CASTED.afterWorldTick();
    }

    @Overwrite
    public void onPreClientTick() {
        this.bus().post((Event)START_CLIENT_TICK_EVENT);
    }

    @Overwrite
    public void onPostClientTick() {
        this.bus().post((Event)END_CLIENT_TICK_EVENT);
    }

    @Overwrite
    public void onRenderTickStart(float timer) {
        START_RENDER_TICK_EVENT_CASTED.beforeRenderTick(timer);
        this.bus().post((Event)START_RENDER_TICK_EVENT);
    }

    @Overwrite
    public void onRenderTickEnd(float timer) {
        this.bus().post((Event)END_RENDER_TICK_EVENT);
    }

    @Overwrite
    public void onPlayerPreTick(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            SERVER_START_PLAYER_TICK_EVENT_CASTED.beforePlayerTick(player);
            this.bus().post((Event)SERVER_START_PLAYER_TICK_EVENT);
            SERVER_START_PLAYER_TICK_EVENT_CASTED.afterPlayerTick();
        } else {
            CLIENT_START_PLAYER_TICK_EVENT_CASTED.beforePlayerTick(player);
            this.bus().post((Event)CLIENT_START_PLAYER_TICK_EVENT);
            CLIENT_START_PLAYER_TICK_EVENT_CASTED.afterPlayerTick();
        }
    }

    @Overwrite
    public void onPlayerPostTick(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            SERVER_END_PLAYER_TICK_EVENT_CASTED.beforePlayerTick(player);
            this.bus().post((Event)SERVER_END_PLAYER_TICK_EVENT);
            SERVER_END_PLAYER_TICK_EVENT_CASTED.afterPlayerTick();
        } else {
            CLIENT_END_PLAYER_TICK_EVENT_CASTED.beforePlayerTick(player);
            this.bus().post((Event)CLIENT_END_PLAYER_TICK_EVENT);
            CLIENT_END_PLAYER_TICK_EVENT_CASTED.afterPlayerTick();
        }
    }
}

