/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.sprite.ondemand;

import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import zone.rong.loliasm.client.sprite.ondemand.FloorUV;

public class FloorUVTree {
    private static final float nullKey = -1.0f;
    private final Tree<Tree<TextureAtlasSprite>> uTree = new Tree();
    private static final boolean RED = false;
    private static final boolean BLACK = true;

    public void put(float minU, float minV, TextureAtlasSprite sprite) {
        Tree<Object> vTree = this.uTree.get(minU);
        if (vTree == null) {
            vTree = new Tree();
            this.uTree.put(minU, vTree);
        }
        vTree.put(minV, sprite);
    }

    @Nullable
    public TextureAtlasSprite getNearestFloorSprite(FloorUV uv) {
        Tree<TextureAtlasSprite> vTree = this.uTree.getFloor(uv.u);
        if (vTree == null) {
            return null;
        }
        return vTree.getFloor(uv.v);
    }

    @Nullable
    public TextureAtlasSprite getNearestFloorSprite(float u, float v) {
        Tree<TextureAtlasSprite> vTree = this.uTree.getFloor(u);
        if (vTree == null) {
            return null;
        }
        return vTree.getFloor(v);
    }

    private static final class Entry<V>
    implements Float2ObjectMap.Entry<V> {
        float key;
        V value;
        Entry<V> left;
        Entry<V> right;
        Entry<V> parent;
        boolean color = true;

        Entry(float key, V value, Entry<V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public float getFloatKey() {
            return this.key;
        }

        @Deprecated
        public Float getKey() {
            return Float.valueOf(this.key);
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return Objects.equals(Float.valueOf(this.key), Float.valueOf(e.getFloatKey())) && Objects.equals(this.value, e.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == -1.0f ? 0 : Float.floatToIntBits(this.key);
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Tree<V> {
        Entry<V> root;
        int size = 0;
        int modCount = 0;

        private Tree() {
        }

        private static <V> boolean colorOf(Entry<V> p) {
            return p == null ? true : p.color;
        }

        private static <V> Entry<V> parentOf(Entry<V> p) {
            return p == null ? null : p.parent;
        }

        private static <V> void setColor(Entry<V> p, boolean c) {
            if (p != null) {
                p.color = c;
            }
        }

        private static <V> Entry<V> leftOf(Entry<V> p) {
            return p == null ? null : p.left;
        }

        private static <V> Entry<V> rightOf(Entry<V> p) {
            return p == null ? null : p.right;
        }

        void put(float key, V value) {
            int cmp;
            Entry<V> parent;
            if (this.root == null) {
                this.root = new Entry<V>(key, value, null);
                this.size = 1;
                ++this.modCount;
                return;
            }
            if (key == -1.0f) {
                throw new NullPointerException();
            }
            Entry<V> t = this.root;
            do {
                parent = t;
                cmp = Float.compare(key, t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                t.setValue(value);
                return;
            } while (t != null);
            Entry<V> e = new Entry<V>(key, value, parent);
            if (cmp < 0) {
                parent.left = e;
            } else {
                parent.right = e;
            }
            this.fixAfterInsertion(e);
            ++this.size;
            ++this.modCount;
        }

        final V get(float key) {
            if (key == -1.0f) {
                throw new NullPointerException();
            }
            Entry<V> p = this.root;
            while (p != null) {
                int cmp = Float.compare(key, p.key);
                if (cmp < 0) {
                    p = p.left;
                    continue;
                }
                if (cmp > 0) {
                    p = p.right;
                    continue;
                }
                return p.value;
            }
            return null;
        }

        @Nullable
        final V getFloor(float key) {
            Entry<V> p = this.root;
            while (p != null) {
                int cmp = Float.compare(key, p.key);
                if (cmp > 0) {
                    if (p.right != null) {
                        p = p.right;
                        continue;
                    }
                    return p.value;
                }
                if (cmp < 0) {
                    if (p.left != null) {
                        p = p.left;
                        continue;
                    }
                    Entry parent = p.parent;
                    Entry<V> ch = p;
                    while (parent != null && ch == parent.left) {
                        ch = parent;
                        parent = parent.parent;
                    }
                    return parent == null ? null : (V)parent.value;
                }
                return p.value;
            }
            return null;
        }

        private void fixAfterInsertion(Entry<V> x) {
            x.color = false;
            while (x != null && x != this.root && !x.parent.color) {
                Entry<V> y;
                if (Tree.parentOf(x) == Tree.leftOf(Tree.parentOf(Tree.parentOf(x)))) {
                    y = Tree.rightOf(Tree.parentOf(Tree.parentOf(x)));
                    if (!Tree.colorOf(y)) {
                        Tree.setColor(Tree.parentOf(x), true);
                        Tree.setColor(y, true);
                        Tree.setColor(Tree.parentOf(Tree.parentOf(x)), false);
                        x = Tree.parentOf(Tree.parentOf(x));
                        continue;
                    }
                    if (x == Tree.rightOf(Tree.parentOf(x))) {
                        x = Tree.parentOf(x);
                        this.rotateLeft(x);
                    }
                    Tree.setColor(Tree.parentOf(x), true);
                    Tree.setColor(Tree.parentOf(Tree.parentOf(x)), false);
                    this.rotateRight(Tree.parentOf(Tree.parentOf(x)));
                    continue;
                }
                y = Tree.leftOf(Tree.parentOf(Tree.parentOf(x)));
                if (!Tree.colorOf(y)) {
                    Tree.setColor(Tree.parentOf(x), true);
                    Tree.setColor(y, true);
                    Tree.setColor(Tree.parentOf(Tree.parentOf(x)), false);
                    x = Tree.parentOf(Tree.parentOf(x));
                    continue;
                }
                if (x == Tree.leftOf(Tree.parentOf(x))) {
                    x = Tree.parentOf(x);
                    this.rotateRight(x);
                }
                Tree.setColor(Tree.parentOf(x), true);
                Tree.setColor(Tree.parentOf(Tree.parentOf(x)), false);
                this.rotateLeft(Tree.parentOf(Tree.parentOf(x)));
            }
            this.root.color = true;
        }

        private void rotateLeft(Entry<V> p) {
            if (p != null) {
                Entry r = p.right;
                p.right = r.left;
                if (r.left != null) {
                    r.left.parent = p;
                }
                r.parent = p.parent;
                if (p.parent == null) {
                    this.root = r;
                } else if (p.parent.left == p) {
                    p.parent.left = r;
                } else {
                    p.parent.right = r;
                }
                r.left = p;
                p.parent = r;
            }
        }

        private void rotateRight(Entry<V> p) {
            if (p != null) {
                Entry l = p.left;
                p.left = l.right;
                if (l.right != null) {
                    l.right.parent = p;
                }
                l.parent = p.parent;
                if (p.parent == null) {
                    this.root = l;
                } else if (p.parent.right == p) {
                    p.parent.right = l;
                } else {
                    p.parent.left = l;
                }
                l.right = p;
                p.parent = l;
            }
        }
    }
}

