/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.screenshot.mixins;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import zone.rong.loliasm.client.screenshot.ScreenshotThread;
import zone.rong.loliasm.client.screenshot.mixins.ScreenShotHelperInvoker;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Redirect(method={"dispatchKeypresses"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/ScreenShotHelper;saveScreenshot(Ljava/io/File;IILnet/minecraft/client/shader/Framebuffer;)Lnet/minecraft/util/text/ITextComponent;", ordinal=0))
    private ITextComponent runAsyncScreenshotProcessing(File gameDir, int width, int height, Framebuffer buffer) {
        try {
            BufferedImage screenshot = ScreenShotHelper.func_186719_a((int)width, (int)height, (Framebuffer)buffer);
            File screenshotDir = new File(gameDir, "screenshots");
            screenshotDir.mkdir();
            File screenshotFile = ScreenShotHelperInvoker.invokeGetTimestampedPNGFileForDirectory(screenshotDir).getCanonicalFile();
            ScreenshotEvent event = ForgeHooksClient.onScreenshot((BufferedImage)screenshot, (File)screenshotFile);
            if (event.isCanceled()) {
                return event.getCancelMessage();
            }
            new ScreenshotThread(event.getScreenshotFile(), screenshot, event.getResultMessage()).start();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new TextComponentTranslation("screenshot.failure", new Object[]{e.getMessage()});
        }
    }

    @Redirect(method={"dispatchKeypresses"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiNewChat;printChatMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    private void redirectPrintScreenshotPathInChat(GuiNewChat chat, ITextComponent text) {
    }
}

