/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.whocalled;

import me.nallar.whocalled.WhoCalled;

class WhoCalledStackTrace
implements WhoCalled {
    private static final int OFFSET = 1;

    WhoCalledStackTrace() {
    }

    @Override
    public Class<?> getCallingClass() {
        try {
            return Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    @Override
    public Class<?> getCallingClass(int depth) {
        try {
            return Class.forName(Thread.currentThread().getStackTrace()[1 + depth].getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    @Override
    public boolean isCalledByClass(Class<?> clazz) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

