/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.StorageTerminalContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StorageTerminalTileEntity
extends LogicTileEntity
implements DefaultSidedInventory,
CraftingGridProvider,
JEIRecipeAcceptor {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, StorageTerminalContainer.factory, 1);
    private CraftingGrid craftingGrid = new CraftingGrid();

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public void storeRecipe(int index) {
        this.craftingGrid.storeRecipe(index);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayer player, int n, boolean test) {
        TileEntity te;
        ItemStack module = this.inventoryHelper.getStackInSlot(0);
        if (module.func_190926_b()) {
            return new int[0];
        }
        int dimension = RFToolsTools.getDimensionFromModule(module);
        BlockPos scannerPos = RFToolsTools.getPositionFromModule(module);
        WorldServer world = DimensionManager.getWorld((int)dimension);
        StorageScannerTileEntity scannerTE = null;
        if (WorldTools.chunkLoaded((World)world, (BlockPos)scannerPos) && (te = world.func_175625_s(scannerPos)) instanceof StorageScannerTileEntity) {
            scannerTE = (StorageScannerTileEntity)te;
        }
        if (scannerTE == null) {
            InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.field_71071_by, 0);
            if (test) {
                return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
            }
            StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
            return new int[0];
        }
        return scannerTE.craft(player, n, test, this.craftingGrid.getActiveRecipe());
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean module = !this.inventoryHelper.getStackInSlot(0).func_190926_b();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K) {
            boolean newmodule;
            boolean bl = newmodule = !this.inventoryHelper.getStackInSlot(0).func_190926_b();
            if (newmodule != module) {
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (!this.func_145831_w().field_72995_K) {
            this.markDirtyClient();
        } else {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 0 || stack.func_77973_b() == ScreenSetup.storageControlModuleItem;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }
}

