/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComputerScreenModule
implements IScreenModule<ModuleComputerInfo> {
    private String tag = "";
    private final ModuleComputerInfo textList = new ModuleComputerInfo();

    @Override
    public ModuleComputerInfo getData(IScreenDataHelper helper, World worldObj, long millis) {
        return this.textList;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.tag = tagCompound.func_74779_i("moduleTag");
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void addText(String text, int color) {
        this.textList.add(new ColoredText(text, color));
    }

    public void clearText() {
        this.textList.clear();
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.COMPUTER_RFPERTICK.get();
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }

    @Override
    public boolean needsController() {
        return true;
    }

    public static class ModuleComputerInfo
    extends ArrayList<ColoredText>
    implements IModuleData {
        public static final String ID = "rftools:computer";

        @Override
        public String getId() {
            return ID;
        }

        public ModuleComputerInfo() {
        }

        public ModuleComputerInfo(ByteBuf buf) {
            for (int i = buf.readInt(); i > 0; --i) {
                this.add(new ColoredText(NetworkTools.readString((ByteBuf)buf), buf.readInt()));
            }
        }

        @Override
        public void writeToBuf(ByteBuf buf) {
            buf.writeInt(this.size());
            for (ColoredText i : this) {
                NetworkTools.writeString((ByteBuf)buf, (String)i.getText());
                buf.writeInt(i.getColor());
            }
        }
    }

    public static class ColoredText {
        private final String text;
        private final int color;

        public ColoredText(String text, int color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }
    }
}

