/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenControllerContainer;
import mcjty.rftools.blocks.screens.ScreenControllerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiScreenController
extends GenericGuiContainer<ScreenControllerTileEntity> {
    public static final int CONTROLLER_WIDTH = 180;
    public static final int CONTROLLER_HEIGHT = 152;
    private EnergyBar energyBar;
    private Label infoLabel;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/screencontroller.png");

    public GuiScreenController(ScreenControllerTileEntity screenControllerTileEntity, ScreenControllerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)screenControllerTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "screens");
        GenericEnergyStorageTileEntity.setCurrentRF((long)screenControllerTileEntity.getStoredPower());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        long maxEnergyStored = ((ScreenControllerTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(10, 7, 8, 54)).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        Button scanButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("scan")).setText("Scan")).setTooltips(new String[]{"Find all nearby screens", "and connect to them"})).setLayoutHint(30, 7, 50, 14);
        Button detachButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("detach")).setText("Detach")).setTooltips(new String[]{"Detach from all screens"})).setLayoutHint(90, 7, 50, 14);
        this.infoLabel = new Label(this.field_146297_k, (Gui)this);
        this.infoLabel.setLayoutHint(30, 25, 140, 14);
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.energyBar, scanButton, detachButton, this.infoLabel});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        ((ScreenControllerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        this.window.action(RFToolsMessages.INSTANCE, "scan", (GenericTileEntity)((ScreenControllerTileEntity)this.tileEntity), "scan");
        this.window.action(RFToolsMessages.INSTANCE, "detach", (GenericTileEntity)((ScreenControllerTileEntity)this.tileEntity), "detach");
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.infoLabel.setText(((ScreenControllerTileEntity)this.tileEntity).getConnectedScreens().size() + " connected screens");
        ((ScreenControllerTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }
}

