/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpaceChamberRepository
extends AbstractWorldData<SpaceChamberRepository> {
    private static final String SPACECHAMBER_CHANNELS_NAME = "RFToolsSpaceChambers";
    private int lastId = 0;
    private final Map<Integer, SpaceChamberChannel> channels = new HashMap<Integer, SpaceChamberChannel>();

    public SpaceChamberRepository(String name) {
        super(name);
    }

    public void clear() {
        this.channels.clear();
        this.lastId = 0;
    }

    public static SpaceChamberRepository getChannels(World world) {
        return (SpaceChamberRepository)SpaceChamberRepository.getData(SpaceChamberRepository.class, (String)SPACECHAMBER_CHANNELS_NAME);
    }

    public SpaceChamberChannel getOrCreateChannel(int id) {
        SpaceChamberChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new SpaceChamberChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public SpaceChamberChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.channels.clear();
        NBTTagList lst = tagCompound.func_150295_c("channels", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            SpaceChamberChannel value = new SpaceChamberChannel();
            value.setDimension(tc.func_74762_e("dimension"));
            value.setMinCorner(BlockPosTools.readFromNBT((NBTTagCompound)tc, (String)"minCorner"));
            value.setMaxCorner(BlockPosTools.readFromNBT((NBTTagCompound)tc, (String)"maxCorner"));
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, SpaceChamberChannel> entry : this.channels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            tc.func_74768_a("dimension", entry.getValue().getDimension());
            BlockPosTools.writeToNBT((NBTTagCompound)tc, (String)"minCorner", (BlockPos)entry.getValue().getMinCorner());
            BlockPosTools.writeToNBT((NBTTagCompound)tc, (String)"maxCorner", (BlockPos)entry.getValue().getMaxCorner());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("channels", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class SpaceChamberChannel {
        private int dimension;
        private BlockPos minCorner = null;
        private BlockPos maxCorner = null;

        public int getDimension() {
            return this.dimension;
        }

        public void setDimension(int dimension) {
            this.dimension = dimension;
        }

        public BlockPos getMinCorner() {
            return this.minCorner;
        }

        public void setMinCorner(BlockPos minCorner) {
            this.minCorner = minCorner;
        }

        public BlockPos getMaxCorner() {
            return this.maxCorner;
        }

        public void setMaxCorner(BlockPos maxCorner) {
            this.maxCorner = maxCorner;
        }
    }
}

