/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.crafttweaker;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.storagedrawers.OreDictionaryWhitelist")
public class OreDictionaryWhitelist {
    @ZenMethod
    public static void add(String name) {
        if (name != null && name.length() > 0) {
            CraftTweakerAPI.apply((IAction)new AddNameAction(name));
        } else {
            CraftTweakerAPI.logError((String)"Tried to add empty ore dictionary name to drawer conversion whitelist.");
        }
    }

    @ZenMethod
    public static void remove(String name) {
        if (name != null && name.length() > 0) {
            CraftTweakerAPI.apply((IAction)new RemoveNameAction(name));
        } else {
            CraftTweakerAPI.logError((String)"Tried to remove empty ore dictionary name from drawer conversion whitelist.");
        }
    }

    private static class AddNameAction
    implements IAction {
        String name;

        public AddNameAction(String name) {
            this.name = name;
        }

        public void apply() {
            boolean added = StorageDrawers.oreDictRegistry.addWhitelist(this.name);
            if (!added) {
                CraftTweakerAPI.logWarning((String)("Ore dictionary key '" + this.name + "' already registered in drawer conversion whitelist."));
            }
        }

        public String describe() {
            return "Adding ore dictionary key '" + this.name + "' to drawer conversion whitelist.";
        }
    }

    private static class RemoveNameAction
    implements IAction {
        String name;

        public RemoveNameAction(String name) {
            this.name = name;
        }

        public void apply() {
            StorageDrawers.oreDictRegistry.removeWhitelist(this.name);
        }

        public String describe() {
            return "Removing existing ore dictionary key '" + this.name + "' from drawer conversion whitelist.";
        }
    }
}

