/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.util;

import io.netty.buffer.ByteBuf;
import omtteam.openmodularturrets.tileentity.turrets.AbstractDirectedTurret;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;

public class TurretHeadSettings {
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public boolean forceFire;
    private boolean isDirected = false;

    public TurretHeadSettings() {
    }

    public TurretHeadSettings(float yaw, float pitch, boolean forceFire) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.forceFire = forceFire;
    }

    public TurretHeadSettings(TurretHead turretHead) {
        if (turretHead instanceof AbstractDirectedTurret) {
            this.yaw = ((AbstractDirectedTurret)turretHead).getYaw();
            this.pitch = ((AbstractDirectedTurret)turretHead).getPitch();
            this.isDirected = true;
        }
        this.forceFire = turretHead.getAutoFire();
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.forceFire);
    }

    public TurretHeadSettings readFromBuf(ByteBuf buf) {
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.forceFire = buf.readBoolean();
        return this;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean directed) {
        this.isDirected = directed;
    }
}

