/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks.turretheads;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import omtteam.omlib.api.block.IHasItemBlock;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.compatibility.theoneprobe.TOPCompatibility;
import omtteam.omlib.compatibility.theoneprobe.TOPInfoProvider;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.MathUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.api.ITurretBaseAddonBlock;
import omtteam.openmodularturrets.blocks.BlockTurretBase;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.OMTUtil;
import omtteam.openmodularturrets.util.TurretHeadUtil;
import omtteam.openmodularturrets.util.TurretType;

public abstract class BlockAbstractTurretHead
extends BlockAbstractTileEntity
implements IHasItemBlock,
ITurretBaseAddonBlock,
TOPInfoProvider {
    public static final PropertyBool CONCEALED = PropertyBool.func_177716_a((String)"concealed");

    BlockAbstractTurretHead() {
        super(Material.field_151592_s);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (OMTConfig.TURRETS.turretBreakable) {
            this.func_149722_s();
            this.func_149752_b(6000000.0f);
        } else {
            this.func_149711_c(40.0f);
            this.func_149752_b(25.0f);
        }
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CONCEALED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)CONCEALED)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    }

    @Override
    public AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing, World world, BlockPos pos) {
        facing = TurretHeadUtil.getTurretBaseFacing((IBlockAccess)world, pos);
        if (facing != null) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)-0.3f, (double)-0.3f, -0.5, (double)0.3f, (double)0.3f, 0.5);
            axisAlignedBB = MathUtil.rotateAABB((AxisAlignedBB)axisAlignedBB, (EnumFacing)facing.func_176734_d());
            return axisAlignedBB.func_186670_a(pos).func_72317_d(0.5, 0.5, 0.5);
        }
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f).func_186670_a(pos);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONCEALED, (Comparable)Boolean.valueOf(meta == 1));
    }

    @ParametersAreNonnullByDefault
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CONCEALED) != false ? 1 : 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONCEALED});
    }

    @ParametersAreNonnullByDefault
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        TurretBase base = this.getBase(worldIn, pos);
        return base != null && OMTUtil.getRemainingTurretSlots(base, this.getTurretType()) > 0;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TurretBase base = this.getBase(worldIn, pos);
        if (this.getTurretType().getSettings().baseRange > base.getCurrentMaxRange()) {
            base.setUpdateRange(true);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity head = world.func_175625_s(pos);
        if (head instanceof TurretHead && !head.func_145831_w().field_72995_K && ((TurretHead)head).getBase() != null && ((TurretHead)head).getBase().func_174877_v().equals((Object)neighbor) && !(world.func_180495_p(neighbor).func_177230_c() instanceof BlockTurretBase)) {
            head.func_145831_w().func_175655_b(pos, true);
        }
    }

    @ParametersAreNonnullByDefault
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (OMTConfig.TURRETS.turretBreakable) {
            return 40.0f;
        }
        return -1.0f;
    }

    @ParametersAreNonnullByDefault
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (OMTConfig.TURRETS.turretBreakable) {
            return 25.0f;
        }
        return 600000.0f;
    }

    public abstract TurretType getTurretType();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TurretHead) {
            TurretHead turret = (TurretHead)te;
            boolean active = turret.getBase().isActive();
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanColor((boolean)active) + TOPCompatibility.getLocalizationString((String)GeneralUtil.getBooleanUnlocalizationYesNo((boolean)active)), probeInfo.defaultTextStyle());
            String ownerName = turret.getBase().getOwner().getName();
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.omlib:owner") + ": \u00a7F" + ownerName, probeInfo.defaultTextStyle());
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.openmodularturrets:ammo") + ": \u00a7F" + TurretHeadUtil.getAmmoLevel(turret, turret.getBase()), probeInfo.defaultTextStyle());
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.openmodularturrets:damage_amp") + ": \u00a7F" + String.format("%.2f", turret.getTurretDamageAmpBonus() * 100.0 * (double)TurretHeadUtil.getAmpLevel(turret.getBase())) + "%", probeInfo.defaultTextStyle());
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.openmodularturrets:accuracy") + ": \u00a7F" + String.format("%.2f", Math.min(100.0, 100.0 - turret.getActualTurretAccuracy())) + "%", probeInfo.defaultTextStyle());
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.openmodularturrets:rof") + ": \u00a7F" + String.format("%.2f", Float.valueOf(20.0f / ((float)turret.getTurretBaseFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(turret.getBase(), turret))))) + "s/sec", probeInfo.defaultTextStyle());
        }
    }
}

