/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketSidedWrapper
extends PacketBase {
    private BlockPos posTile;
    private byte[] indexes;

    public PacketSidedWrapper() {
    }

    public PacketSidedWrapper(BlockPos posTile, byte[] indexes) {
        this.posTile = posTile;
        this.indexes = indexes;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.posTile);
        buffer.func_179250_a(this.indexes);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.posTile = buffer.func_179259_c();
        this.indexes = buffer.func_179251_a();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        TileEntity tileEntity = player.func_130014_f_().func_175625_s(this.posTile);
        if (tileEntity instanceof ISidedWrapper) {
            ISidedWrapper.SidedWrapper sidedWrapper = ((ISidedWrapper)tileEntity).getSidedWrapper();
            for (EnumFacing facing : EnumFacing.values()) {
                sidedWrapper.setFaceIndex(facing, this.indexes[facing.func_176745_a()]);
            }
            Function.syncTile(tileEntity);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSidedWrapper, IMessage> {
        public IMessage onMessage(PacketSidedWrapper packet, MessageContext ctx) {
            NetworkHandler.onMessage(packet, ctx);
            return null;
        }
    }
}

