/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketConfig;

public class EventHandler {
    private boolean syncConfig = false;

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        BlockPos pos;
        World world;
        IBonemealable bonemealable;
        IBlockState state = event.getBlock();
        if (state != null && state.func_177230_c() instanceof IBonemealable && (bonemealable = (IBonemealable)state.func_177230_c()).canGrow(world = event.getWorld(), pos = event.getPos(), state, world.field_72995_K)) {
            if (!world.field_72995_K && bonemealable.canUseBonemeal(world, world.field_73012_v, pos, state)) {
                bonemealable.grow(world, world.field_73012_v, pos, state);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        String dyeName;
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || event.getItemStack().func_190926_b()) {
            return;
        }
        IBlockState state = player.func_130014_f_().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block instanceof IRGB16_Block && !Strings.isNullOrEmpty((String)(dyeName = DyeHelper.getDyeName(event.getItemStack()))) && ((IRGB16_Block)block).recolorBlock(state, player.func_130014_f_(), event.getPos(), player, event.getHand(), event.getFace(), event.getHitVec(), dyeName)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerJoinedServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.syncConfig = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (this.syncConfig && event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerSP) {
            this.syncConfig = false;
            Minecraft.func_71410_x().func_152344_a(() -> NetworkHandler.sendToServer(new PacketConfig()));
        }
    }
}

