/*
 * Decompiled with CFR 0.152.
 */
package topextras.providers.modcompat;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import topextras.Utilities;

public class DynamicTreesInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return Utilities.getProviderId("dynamic_trees");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, @Nonnull IBlockState blockState, IProbeHitData data) {
        Species species;
        Block block = blockState.func_177230_c();
        if (block instanceof BlockRooty) {
            int life = ((BlockRooty)block).getSoilLife(blockState, (IBlockAccess)world, data.getPos());
            probeInfo.text(TextStyleClass.LABEL + "{*topextras.dynamic_trees.soil_life*} " + TextStyleClass.INFO + Math.floor((float)life * 100.0f / 15.0f) + "%");
        } else if ((block instanceof BlockBranch || block instanceof BlockTrunkShell) && (species = TreeHelper.getBestGuessSpecies((World)world, (BlockPos)data.getPos())) != Species.NULLSPECIES) {
            probeInfo.text(TextStyleClass.LABEL + "{*topextras.dynamic_trees.species*} " + TextStyleClass.INFO + species.getLocalizedName());
            IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.item(species.getSeedStack(1));
            float volume = DynamicTreesInfoProvider.getTreeVolume(world, blockState, block, data.getPos());
            if (volume > 0.0f) {
                Species.LogsAndSticks logsAndSticks = species.getLogsAndSticks(volume);
                if (logsAndSticks.logs > 0) {
                    horizontalPane.item(species.getFamily().getPrimitiveLogItemStack(logsAndSticks.logs));
                }
                if (logsAndSticks.sticks > 0) {
                    horizontalPane.item(species.getFamily().getStick(logsAndSticks.sticks));
                }
            }
        }
    }

    private static float getTreeVolume(@Nonnull World world, @Nonnull IBlockState state, @Nonnull Block block, @Nonnull BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        if (block instanceof BlockTrunkShell && (muse = ((BlockTrunkShell)block).getMuse((IBlockAccess)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)block;
            NodeNetVolume volumeSum = new NodeNetVolume();
            branch.analyse(state, world, pos, null, new MapSignal(new INodeInspector[]{volumeSum}));
            return volumeSum.getVolume() * ModConfigs.treeHarvestMultiplier;
        }
        return 0.0f;
    }
}

