/*
 * Decompiled with CFR 0.152.
 */
package topextras.providers;

import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import topextras.Utilities;

public class FurnaceInfoProvider
implements IProbeInfoProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);

    public String getID() {
        return Utilities.getProviderId("furnace");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, @Nonnull World world, @Nonnull IBlockState blockState, @Nonnull IProbeHitData data) {
        if (blockState.func_177230_c() instanceof BlockFurnace && blockState.func_177230_c().hasTileEntity(blockState)) {
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (tileEntity == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            tileEntity.func_189515_b(compound);
            int totalCookTime = compound.func_74762_e("CookTimeTotal");
            int fuelTime = compound.func_74762_e("BurnTime");
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
            ItemStack fuel = (ItemStack)this.inventory.get(1);
            ItemStack input = (ItemStack)this.inventory.get(0);
            this.inventory.clear();
            if (totalCookTime > 0 && !input.func_190926_b()) {
                String text;
                int cookTime = compound.func_74762_e("CookTime");
                int maxProgress = totalCookTime;
                if (maxProgress < 20) {
                    text = String.format(" t / %s t", maxProgress);
                } else {
                    cookTime = Math.round((float)cookTime / 20.0f);
                    maxProgress = Math.round((float)maxProgress / 20.0f);
                    text = String.format(" s / %s s", maxProgress);
                }
                probeInfo.progress(cookTime, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(-11748585).alternateFilledColor(-11748585).backgroundColor(0xFFFFFF));
            }
            IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            if (!fuel.func_190926_b() || fuelTime != 0) {
                int baseBurnTime = 0;
                if (!fuel.func_190926_b()) {
                    horizontalPane.item(fuel);
                    baseBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                }
                float smeltableAmount = 0.0f;
                float itemSmeltDuration = totalCookTime == 0 ? 200.0f : 1.0f * (float)totalCookTime;
                smeltableAmount += (float)fuelTime / itemSmeltDuration;
                if ((smeltableAmount += (float)(baseBurnTime * Math.max(1, fuel.func_190916_E())) / itemSmeltDuration) > 0.0f) {
                    horizontalPane.text(TextStyleClass.LABEL + " {*topextras.top.furnace_fuel*} " + TextStyleClass.OK + Utilities.FORMAT.format(smeltableAmount) + TextStyleClass.LABEL + " {*topextras.top.items*}");
                }
            } else if (!input.func_190926_b()) {
                horizontalPane.text(TextStyleClass.WARNING + "{*topextras.top.no_fuel*}");
            }
        }
    }
}

