/*
 * Decompiled with CFR 0.152.
 */
package topextras;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class Utilities {
    public static final String MODID_DYNAMIC_TREES = "dynamictrees";
    public static final String MODID_APOTHEOSIS = "apotheosis";
    public static final DecimalFormat FORMAT = new DecimalFormat("#,###.#");

    @Nonnull
    public static String getProviderId(@Nonnull String name) {
        return String.format("%s:%s_provider", "topextras", name);
    }

    public static void addItemStack(@Nonnull List<ItemStack> stacks, @Nonnull Set<Item> foundItems, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.func_190917_f(stack.func_190916_E());
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        foundItems.add(stack.func_77973_b());
    }

    public static void showChestContents(@Nonnull IProbeInfo probeInfo, @Nonnull List<ItemStack> stacks, @Nonnull ProbeMode mode) {
        IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)).spacing(0));
        int rows = 0;
        int idx = 0;
        if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowChestContentsDetailed()) && stacks.size() <= Config.showItemDetailThresshold) {
            for (ItemStack stackInSlot : stacks) {
                vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stackInSlot, new ItemStyle().width(16).height(16)).text(TextStyleClass.INFO + stackInSlot.func_82833_r());
            }
        } else {
            IProbeInfo horizontal = null;
            for (ItemStack stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal((ILayoutStyle)new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }
}

