/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.world.chunk.gen;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class StructureBoundingBoxes {
    public static Set<ChunkPos> rasterize(StructureBoundingBox boundingBox) {
        if (boundingBox != null) {
            int minX = boundingBox.field_78897_a >> 4;
            int maxX = boundingBox.field_78893_d >> 4;
            int minZ = boundingBox.field_78896_c >> 4;
            int maxZ = boundingBox.field_78892_f >> 4;
            HashSet<ChunkPos> pairs = new HashSet<ChunkPos>((maxX - minX + 1) * (maxZ - minZ + 1));
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    pairs.add(new ChunkPos(x, z));
                }
            }
            return pairs;
        }
        return Collections.emptySet();
    }

    public static boolean fitsY(StructureBoundingBox boundingBox, int minY, int maxY) {
        return boundingBox.field_78895_b >= minY && boundingBox.field_78894_e < maxY;
    }

    @Nonnull
    public static StructureBoundingBox wholeHeightBoundingBox(WorldServer world, StructureBoundingBox generationBB) {
        StructureBoundingBox toFloorBB = new StructureBoundingBox(generationBB);
        toFloorBB.field_78895_b = 1;
        toFloorBB.field_78894_e = world.func_72800_K();
        return toFloorBB;
    }

    @Nonnull
    public static BlockPos min(StructureBoundingBox boundingBox) {
        return new BlockPos(boundingBox.field_78897_a, boundingBox.field_78895_b, boundingBox.field_78896_c);
    }

    @Nonnull
    public static BlockPos max(StructureBoundingBox boundingBox) {
        return new BlockPos(boundingBox.field_78893_d, boundingBox.field_78894_e, boundingBox.field_78892_f);
    }

    public static int[] size(StructureBoundingBox boundingBox) {
        return new int[]{boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d()};
    }
}

