/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.world.chunk;

import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.util.IvStreams;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.ChunkPos;

public class Chunks {
    public static boolean contains(ChunkPos chunkPos, BlockSurfacePos pos) {
        return chunkPos.field_77276_a == pos.x >> 4 && chunkPos.field_77275_b == pos.z >> 4;
    }

    public static Stream<BlockSurfacePos> repeatIntersections(ChunkPos chunkPos, BlockSurfacePos pos, int repeatX, int repeatZ) {
        int lowestX = pos.x + ((chunkPos.field_77276_a << 4) - pos.x) / repeatX * repeatX;
        int lowestZ = pos.z + ((chunkPos.field_77275_b << 4) - pos.z) / repeatZ * repeatZ;
        int repeatsX = (15 - (lowestX - (chunkPos.field_77276_a << 4))) / repeatX;
        int repeatsZ = (15 - (lowestZ - (chunkPos.field_77275_b << 4))) / repeatZ;
        return IvStreams.flatMapToObj(IntStream.range(0, repeatsX + 1), iX -> IntStream.range(0, repeatsZ + 1).mapToObj(iZ -> new BlockSurfacePos(lowestX + iX * repeatX, lowestZ + iZ * repeatZ)));
    }
}

