/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.strings;

import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LayeredStringGenerator {
    public Layer baseLayer;

    public LayeredStringGenerator(Layer baseLayer) {
        this.baseLayer = baseLayer;
    }

    public String randomString(Random random) {
        return this.baseLayer.randomString(random);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public static class LayerUppercase
    implements Layer {
        public Layer parent;

        public LayerUppercase(Layer parent) {
            this.parent = parent;
        }

        @Override
        public String randomString(Random random) {
            return LayerUppercase.firstCharUppercase(this.parent.randomString(random));
        }

        private static String firstCharUppercase(String name) {
            return Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
        }
    }

    public static class LayerStatic
    implements Layer {
        private List<WeightedSelector.SimpleItem<String>> baseStrings = new ArrayList<WeightedSelector.SimpleItem<String>>();

        public LayerStatic(String ... baseStrings) {
            this.addStrings(1, baseStrings);
        }

        @Deprecated
        public void addStrings(int weight, String ... strings) {
            for (String s : strings) {
                this.baseStrings.add(new WeightedSelector.SimpleItem<String>(weight, s));
            }
        }

        public void addStrings(double weight, String ... strings) {
            for (String s : strings) {
                this.baseStrings.add(new WeightedSelector.SimpleItem<String>(weight, s));
            }
        }

        @Override
        public String randomString(Random random) {
            return (String)WeightedSelector.select(random, this.baseStrings);
        }
    }

    public static class LayerSimple
    implements Layer {
        private Map<Character, Layer> subLayers;
        private List<WeightedSelector.SimpleItem<String>> baseStrings = new ArrayList<WeightedSelector.SimpleItem<String>>();

        public LayerSimple(Map<Character, Layer> subLayers) {
            this.subLayers = subLayers;
        }

        public LayerSimple(Object ... layersForCharacters) {
            this.subLayers = new HashMap<Character, Layer>();
            for (int i = 0; i < layersForCharacters.length / 2; ++i) {
                this.subLayers.put((Character)layersForCharacters[i * 2], (Layer)layersForCharacters[i * 2 + 1]);
            }
        }

        @Deprecated
        public void addStrings(int weight, String ... strings) {
            for (String s : strings) {
                this.baseStrings.add(new WeightedSelector.SimpleItem<String>(weight, s));
            }
        }

        public void addStrings(double weight, String ... strings) {
            for (String s : strings) {
                this.baseStrings.add(new WeightedSelector.SimpleItem<String>(weight, s));
            }
        }

        @Override
        public String randomString(Random random) {
            StringBuilder stringBuilder = new StringBuilder();
            String component = (String)WeightedSelector.select(random, this.baseStrings);
            for (char aChar : component.toCharArray()) {
                Layer subLayer = this.subLayers.get(Character.valueOf(aChar));
                if (subLayer == null) {
                    stringBuilder.append(aChar);
                    continue;
                }
                stringBuilder.append(subLayer.randomString(random));
            }
            return stringBuilder.toString();
        }
    }

    public static interface Layer {
        public String randomString(Random var1);
    }
}

