/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorVines
extends GeneratorReplacing {
    protected int minHeight;
    protected int maxHeight;
    protected int generationAttempts;

    public GeneratorVines(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int minHeight, int maxHeight, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean ret = true;
        block0: for (int i = 0; i < this.generationAttempts; ++i) {
            BlockPos genPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.replace.matches(world, genPos) || !this.placeOn.matches(world, genPos.func_177984_a())) continue;
            IBlockState vineState = this.with;
            ArrayList validDirections = Lists.newArrayList();
            for (EnumFacing facing : EnumFacing.values()) {
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN || !this.placeOn.matches(world, genPos.func_177972_a(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            if (this.with.func_177230_c() instanceof BlockVine) {
                EnumFacing direction = (EnumFacing)validDirections.get(rand.nextInt(validDirections.size()));
                vineState = this.with.func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)direction), (Comparable)Boolean.valueOf(true));
            }
            int targetHeight = GeneratorUtils.nextIntBetween(rand, this.minHeight, this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                BlockPos offsetPos = genPos.func_177979_c(height);
                if (!this.replace.matches(world, offsetPos) || !vineState.func_177230_c().func_176196_c(world, offsetPos)) {
                    ret = false;
                    continue block0;
                }
                world.func_175656_a(offsetPos, vineState);
            }
        }
        return ret;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.with = conf.getBlockState("with", this.with);
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("maxHeight", this.maxHeight);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorVines>
    implements IGenerator.IGeneratorBuilder<GeneratorVines> {
        protected int minHeight;
        protected int maxHeight;
        protected int generationAttempts;

        public Builder minHeight(int a) {
            this.minHeight = a;
            return (Builder)this.self();
        }

        public Builder maxHeight(int a) {
            this.maxHeight = a;
            return (Builder)this.self();
        }

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = new BlockQuery.BlockQueryMaterial(Material.field_151578_c, Material.field_151577_b);
            this.replace = BlockQueries.air;
            this.with = Blocks.field_150395_bd.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.NETHER_ROOF;
            this.minHeight = 2;
            this.maxHeight = 4;
            this.generationAttempts = 12;
        }

        @Override
        public GeneratorVines create() {
            return new GeneratorVines(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minHeight, this.maxHeight, this.generationAttempts);
        }
    }
}

