/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.util.biome.BiomeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class BOPMapGenScatteredFeature
extends MapGenScatteredFeature {
    private static final List<Biome> JUNGLE_BIOMES = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76782_w, Biomes.field_76792_x});
    private static final List<Biome> SWAMP_BIOMES = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76780_h});
    private static final List<Biome> DESERT_BIOMES = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76769_d, Biomes.field_76786_s});
    private static final List<Biome> ICE_BIOMES = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76774_n, Biomes.field_150584_S});
    private final List<Biome.SpawnListEntry> scatteredFeatureSpawnList = Lists.newArrayList();
    private int maxDistanceBetweenScatteredFeatures = 32;
    private final int minDistanceBetweenScatteredFeatures;

    public BOPMapGenScatteredFeature() {
        this.minDistanceBetweenScatteredFeatures = 8;
        this.scatteredFeatureSpawnList.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    public BOPMapGenScatteredFeature(Map<String, String> p_i2061_1_) {
        this();
        for (Map.Entry<String, String> entry : p_i2061_1_.entrySet()) {
            if (!entry.getKey().equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)entry.getValue(), (int)this.maxDistanceBetweenScatteredFeatures, (int)9);
        }
    }

    public String func_143025_a() {
        return "Temple";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int k = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int l = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenScatteredFeatures;
        l *= this.maxDistanceBetweenScatteredFeatures;
        if (i == (k += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8)) && j == (l += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8))) {
            Biome biome = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(i * 16 + 8, 0, j * 16 + 8));
            return biome != null && (JUNGLE_BIOMES.contains(biome) || SWAMP_BIOMES.contains(biome) || DESERT_BIOMES.contains(biome) || ICE_BIOMES.contains(biome));
        }
        return false;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return BOPMapGenScatteredFeature.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public boolean func_175798_a(BlockPos p_175798_1_) {
        StructureStart structurestart = this.func_175797_c(p_175798_1_);
        if (structurestart != null && structurestart instanceof Start && !structurestart.func_186161_c().isEmpty()) {
            StructureComponent structurecomponent = (StructureComponent)structurestart.func_186161_c().get(0);
            return structurecomponent instanceof ComponentScatteredFeaturePieces.SwampHut;
        }
        return false;
    }

    public List<Biome.SpawnListEntry> func_82667_a() {
        return this.scatteredFeatureSpawnList;
    }

    static {
        JUNGLE_BIOMES.addAll(BiomeUtils.filterPresentBiomes(BOPBiomes.bamboo_forest, BOPBiomes.eucalyptus_forest, BOPBiomes.overgrown_cliffs, BOPBiomes.rainforest, BOPBiomes.sacred_springs, BOPBiomes.tropical_rainforest));
        SWAMP_BIOMES.addAll(BiomeUtils.filterPresentBiomes(BOPBiomes.bayou, BOPBiomes.bog, BOPBiomes.dead_swamp, BOPBiomes.fen, BOPBiomes.lush_swamp, BOPBiomes.moor, BOPBiomes.ominous_woods, BOPBiomes.quagmire, BOPBiomes.wetland));
        DESERT_BIOMES.addAll(BiomeUtils.filterPresentBiomes(BOPBiomes.lush_desert, BOPBiomes.outback, BOPBiomes.oasis, BOPBiomes.xeric_shrubland));
        ICE_BIOMES.addAll(BiomeUtils.filterPresentBiomes(BOPBiomes.alps, BOPBiomes.cold_desert, BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_forest));
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            this(worldIn, random, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ, Biome biome) {
            super(chunkX, chunkZ);
            if (JUNGLE_BIOMES.contains(biome)) {
                ComponentScatteredFeaturePieces.JunglePyramid componentscatteredfeaturepieces$junglepyramid = new ComponentScatteredFeaturePieces.JunglePyramid(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(componentscatteredfeaturepieces$junglepyramid);
            } else if (SWAMP_BIOMES.contains(biome)) {
                ComponentScatteredFeaturePieces.SwampHut componentscatteredfeaturepieces$swamphut = new ComponentScatteredFeaturePieces.SwampHut(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(componentscatteredfeaturepieces$swamphut);
            } else if (DESERT_BIOMES.contains(biome)) {
                ComponentScatteredFeaturePieces.DesertPyramid componentscatteredfeaturepieces$desertpyramid = new ComponentScatteredFeaturePieces.DesertPyramid(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(componentscatteredfeaturepieces$desertpyramid);
            } else if (ICE_BIOMES.contains(biome)) {
                ComponentScatteredFeaturePieces.Igloo componentscatteredfeaturepieces$igloo = new ComponentScatteredFeaturePieces.Igloo(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(componentscatteredfeaturepieces$igloo);
            }
            this.func_75072_c();
        }
    }
}

