/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core.transformers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import surreal.fixeroo.core.FixerooPlugin;

public class TypicalTransformer
implements Opcodes {
    static Logger logger = FixerooPlugin.getLogger();

    protected static ClassNode read(String transformedName, byte[] basicClass) {
        logger.info("Transforming {}", (Object)transformedName);
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cls = new ClassNode();
        reader.accept((ClassVisitor)cls, 0);
        return cls;
    }

    protected static byte[] write(ClassNode cls) {
        return TypicalTransformer.write(cls, 1);
    }

    protected static byte[] write(ClassNode cls, int writerOptions) {
        ClassWriter writer = new ClassWriter(writerOptions);
        cls.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    protected static void writeClass(ClassNode cls) {
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            return;
        }
        File file = new File("classOut/" + cls.name + ".class");
        file.getParentFile().mkdirs();
        try {
            OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            ClassWriter writer = new ClassWriter(1);
            cls.accept((ClassVisitor)writer);
            os.write(writer.toByteArray());
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static MethodInsnNode hook(String name, String desc) {
        return new MethodInsnNode(184, "surreal/fixeroo/core/FixerooHooks", name, desc, false);
    }

    protected static String getName(String mcp, String srg) {
        return FMLLaunchHandler.isDeobfuscatedEnvironment() ? mcp : srg;
    }

    protected static AbstractInsnNode getReturn(InsnList instructions) {
        AbstractInsnNode node = instructions.getLast();
        while (node.getOpcode() != 177) {
            node = node.getPrevious();
        }
        return node;
    }
}

