/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core.transformers;

import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import surreal.fixeroo.FixerooConfig;
import surreal.fixeroo.core.transformers.TypicalTransformer;

public class ElytraTransformer
extends TypicalTransformer {
    public static byte[] transformModelPlayer(String transformedName, byte[] basicClass) {
        if (!FixerooConfig.elytraTweaks.enable) {
            return basicClass;
        }
        ClassNode cls = ElytraTransformer.read(transformedName, basicClass);
        block0: for (MethodNode method : cls.methods) {
            if (!method.name.equals(ElytraTransformer.getName("render", "func_78088_a"))) continue;
            String entityLivingBase = "net/minecraft/entity/EntityLivingBase";
            ListIterator iterator = method.instructions.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iterator.next();
                if (node.getOpcode() != 153 || ++i != 2) continue;
                LabelNode label = ((JumpInsnNode)node).label;
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new TypeInsnNode(193, entityLivingBase));
                LabelNode l_ef = new LabelNode();
                list.add((AbstractInsnNode)new JumpInsnNode(153, l_ef));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new TypeInsnNode(192, entityLivingBase));
                list.add((AbstractInsnNode)new MethodInsnNode(182, entityLivingBase, ElytraTransformer.getName("isElytraFlying", "func_184613_cA"), "()Z", false));
                list.add((AbstractInsnNode)new JumpInsnNode(154, label));
                list.add((AbstractInsnNode)l_ef);
                list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                method.instructions.insert(node, list);
                continue block0;
            }
        }
        return ElytraTransformer.write(cls);
    }

    public static byte[] transformRenderPlayer(String transformedName, byte[] basicClass) {
        if (!FixerooConfig.elytraTweaks.enable) {
            return basicClass;
        }
        ClassNode cls = ElytraTransformer.read(transformedName, basicClass);
        block0: for (MethodNode method : cls.methods) {
            InsnList list;
            if (method.name.equals(ElytraTransformer.getName("doRender", "func_76986_a"))) {
                for (AbstractInsnNode node : method.instructions) {
                    if (node.getOpcode() != 182 || !((MethodInsnNode)node).name.equals(ElytraTransformer.getName("isSneaking", "func_70093_af"))) continue;
                    list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    list.add((AbstractInsnNode)ElytraTransformer.hook("RenderPlayer$isSneak", "(ZLnet/minecraft/entity/EntityLivingBase;)Z"));
                    method.instructions.insert(node, list);
                    continue block0;
                }
                continue;
            }
            if (!method.name.equals("setModelVisibilities")) continue;
            for (AbstractInsnNode node : method.instructions) {
                if (node.getOpcode() != 182 || !((MethodInsnNode)node).name.equals(ElytraTransformer.getName("isSneaking", "func_70093_af"))) continue;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)ElytraTransformer.hook("RenderPlayer$isSneak", "(ZLnet/minecraft/entity/EntityLivingBase;)Z"));
                method.instructions.insert(node, list);
                break block0;
            }
            break;
        }
        return ElytraTransformer.write(cls);
    }

    public static byte[] transformEntityPlayer(String transformedName, byte[] basicClass) {
        if (!FixerooConfig.elytraTweaks.enable) {
            return basicClass;
        }
        ClassNode cls = ElytraTransformer.read(transformedName, basicClass);
        for (MethodNode method : cls.methods) {
            if (!method.name.equals(ElytraTransformer.getName("getEyeHeight", "func_70047_e"))) continue;
            AbstractInsnNode node = method.instructions.getLast();
            while (node.getOpcode() != 174) {
                node = node.getPrevious();
            }
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)ElytraTransformer.hook("EntityPlayer$getEyeHeight", "(FLnet/minecraft/entity/player/EntityPlayer;)F"));
            method.instructions.insertBefore(node, list);
            break;
        }
        return ElytraTransformer.write(cls);
    }
}

