/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng;

import appeng.api.config.Upgrades;
import io.github.phantamanta44.threng.block.BlockMachine;
import io.github.phantamanta44.threng.event.TileReadyHandler;
import io.github.phantamanta44.threng.integration.IntegrationManager;
import io.github.phantamanta44.threng.item.ItemMaterial;
import io.github.phantamanta44.threng.recipe.ThrEngRecipes;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy {
    private final IntegrationManager intManager = new IntegrationManager();
    private final Deque<Runnable> postInitTasks = new LinkedList<Runnable>();
    private boolean postPostInit = false;
    private final TileReadyHandler tileReadyer = new TileReadyHandler();

    public void onPreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this.tileReadyer);
        ThrEngRecipes.registerRecipeTypes();
        this.intManager.load(event.getAsmData());
    }

    public void onInit(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"ingotFluixSteel", (ItemStack)ItemMaterial.Type.FLUIX_STEEL.newStack(1));
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)ItemMaterial.Type.COAL_DUST.newStack(1));
        ThrEngRecipes.addRecipes();
        Upgrades.SPEED.registerItem(BlockMachine.Type.AGGREGATOR.newStack(1), 8);
        Upgrades.SPEED.registerItem(BlockMachine.Type.CENTRIFUGE.newStack(1), 8);
        Upgrades.SPEED.registerItem(BlockMachine.Type.ETCHER.newStack(1), 8);
        this.intManager.init();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.postPostInit = true;
        while (!this.postInitTasks.isEmpty()) {
            this.postInitTasks.pop().run();
        }
    }

    public void registerPostInitTask(Runnable task) {
        if (this.postPostInit) {
            task.run();
        } else {
            this.postInitTasks.add(task);
        }
    }

    public TileReadyHandler getTileReadyHandler() {
        return this.tileReadyer;
    }
}

