/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.common.entity.Drone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.items.ItemCard;
import pcl.opensecurity.common.items.ItemRFIDCard;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntityRFIDReader
extends TileEntityOSBase {
    public String data;
    public String eventName = "magData";

    public TileEntityRFIDReader() {
        super("os_rfidreader");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public TileEntityRFIDReader(EnvironmentHost host) {
        super("os_rfidreader", host);
    }

    private HashMap<String, Object> info(Entity entity, String data, String uuid, boolean locked) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        double rangeToEntity = entity.func_70011_f((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        String name = entity instanceof EntityPlayerMP ? ((EntityPlayer)entity).getDisplayNameString() : entity.func_70005_c_();
        this.node.sendToReachable("computer.signal", new Object[]{"rfidData", name, rangeToEntity, data, uuid});
        value.put("name", name);
        value.put("range", rangeToEntity);
        value.put("data", data);
        value.put("uuid", uuid);
        value.put("locked", locked);
        return value;
    }

    ArrayList<RFIDCard> scanInventory(IInventory inv) {
        ArrayList<RFIDCard> cards = new ArrayList<RFIDCard>();
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack st = inv.func_70301_a(k);
            if (!(st.func_77973_b() instanceof ItemRFIDCard)) continue;
            cards.add(new RFIDCard(st));
        }
        return cards;
    }

    private HashMap<Integer, HashMap<String, Object>> scan(int range) {
        HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>();
        int index = 1;
        for (Entity entity : this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-range, -range, -range), this.func_174877_v().func_177982_a(range + 1, range + 1, range + 1)))) {
            if (entity instanceof EntityPlayer) {
                for (RFIDCard card : this.scanInventory((IInventory)((EntityPlayer)entity).field_71071_by)) {
                    if (!card.tag.isValid) continue;
                    output.put(index++, this.info(entity, card.tag.dataTag, card.tag.localUUID, card.tag.locked));
                }
            } else if (entity instanceof Drone) {
                for (RFIDCard card : this.scanInventory((IInventory)((Drone)entity).mainInventory())) {
                    if (!card.tag.isValid) continue;
                    output.put(index++, this.info(entity, card.tag.dataTag, card.tag.localUUID, card.tag.locked));
                }
            }
            ItemCard.CardTag entityTag = new ItemCard.CardTag(entity.getEntityData().func_74775_l("rfidData"));
            if (!entityTag.isValid) continue;
            output.put(index++, this.info(entity, entityTag.dataTag, entityTag.localUUID, entityTag.locked));
        }
        return output;
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a card is swipped", direct=true)
    public Object[] setEventName(Context context, Arguments args) {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Callback(doc="function(optional:int:range):string; pushes a signal \"rfidData\" for each found rfid on all players in range, optional set range.")
    public Object[] scan(Context context, Arguments args) {
        int range = Math.min(OpenSecurity.rfidRange, args.optInteger(0, OpenSecurity.rfidRange));
        if (this.node.changeBuffer((double)(-5 * range)) == 0.0) {
            return new Object[]{this.scan(range)};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }

    static class RFIDCard {
        ItemCard.CardTag tag;

        public RFIDCard(ItemStack st) {
            if (!(st.func_77973_b() instanceof ItemRFIDCard)) {
                return;
            }
            this.tag = new ItemCard.CardTag(st);
        }
    }
}

