/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.blocks.BlockNanoFog;
import pcl.opensecurity.common.entity.EntityNanoFogSwarm;
import pcl.opensecurity.common.items.ItemNanoDNA;
import pcl.opensecurity.common.tileentity.TileEntityNanoFog;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;
import pcl.opensecurity.util.BlockUtils;
import pcl.opensecurity.util.ClassHelper;
import pcl.opensecurity.util.ItemUtils;

public class TileEntityNanoFogTerminal
extends TileEntityOSBase
implements ITickable {
    public static final int terminalRange = 32;
    public static final int FogBlockLimit = 256;
    public static final int FogBuildCost = 50;
    public static final int FogUpkeepCost = 1;
    public static final int maxKnockback = 2;
    public static final int maxDamage = 5;
    public static final int knockbackCost = 2;
    public static final int damageCost = 5;
    public static final int inventorySlots = 7;
    private FakePlayer fakePlayer;
    private ItemStackHandler inventory;
    private int livingTicks = 0;
    private HashSet<BlockPos> fogBlocks = new HashSet();

    public TileEntityNanoFogTerminal() {
        super("os_nanofog_terminal");
        this.inventory = new ItemStackHandler(7);
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(512.0).create();
    }

    public void removed() {
        this.resetAllBlocks();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemUtils.dropItem(this.inventory.getStackInSlot(slot), this.func_145831_w(), this.func_174877_v(), false, 10);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public HashSet<BlockPos> getFogBlocks() {
        return this.fogBlocks;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.livingTicks++ < 100) {
            return;
        }
        if (!this.consumeUpkeepEnergy()) {
            this.resetAllBlocks();
        }
    }

    @Callback(doc="function():boolean; returns material buffer", direct=true)
    public Object[] getMaterial(Context context, Arguments args) {
        return new Object[]{this.inventory.getStackInSlot(0)};
    }

    @Callback(doc="function():array; returns fog locations", direct=true)
    public Object[] getBlocks(Context context, Arguments args) {
        return new Object[]{this.getFogBlocks().toArray()};
    }

    @Callback(doc="function(int x, int y, int z, string material [, int metaindex]):boolean; set a block", direct=false)
    public synchronized Object[] set(Context context, Arguments args) {
        if (args.count() < 4) {
            return new Object[]{"not enough arguments"};
        }
        BlockPos worldPosition = this.getPos(args);
        if (worldPosition == null) {
            return new Object[]{false, "invalid arguments"};
        }
        String material = args.checkString(3);
        int metadata = args.count() > 4 ? args.checkInteger(4) : 0;
        return this.setBlock(worldPosition, material, metadata);
    }

    @Callback(doc="function(int x1, int y1, int z1, int x2, int y2, int z2, string material [, int metaindex]):boolean; set a block", direct=false)
    public synchronized Object[] setArea(Context context, Arguments args) {
        if (args.count() < 7) {
            return new Object[]{"not enough arguments"};
        }
        BlockPos worldPositionA = this.getPos(args);
        BlockPos worldPositionB = this.getPos(args, 3);
        if (worldPositionA == null || worldPositionB == null) {
            return new Object[]{false, "invalid arguments"};
        }
        String material = args.checkString(6);
        int metadata = args.count() > 7 ? args.checkInteger(7) : 0;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int x = worldPositionA.func_177958_n(); x <= worldPositionB.func_177958_n(); ++x) {
            for (int y = worldPositionA.func_177956_o(); y <= worldPositionB.func_177956_o(); ++y) {
                for (int z = worldPositionA.func_177952_p(); z <= worldPositionB.func_177952_p(); ++z) {
                    list.add(this.setBlock(new BlockPos(x, y, z), material, metadata));
                }
            }
        }
        return new Object[]{list.toArray()};
    }

    @Callback(doc="function(int x1, int y1, int z1, int x2, int y2, int z2, string material [, int metaindex]):boolean; set a block", direct=false)
    public synchronized Object[] resetArea(Context context, Arguments args) {
        if (args.count() < 7) {
            return new Object[]{"not enough arguments"};
        }
        BlockPos worldPositionA = this.getPos(args);
        BlockPos worldPositionB = this.getPos(args, 3);
        if (worldPositionA == null || worldPositionB == null) {
            return new Object[]{false, "invalid arguments"};
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int x = worldPositionA.func_177958_n(); x <= worldPositionB.func_177958_n(); ++x) {
            for (int y = worldPositionA.func_177956_o(); y <= worldPositionB.func_177956_o(); ++y) {
                for (int z = worldPositionA.func_177952_p(); z <= worldPositionB.func_177952_p(); ++z) {
                    list.add(this.removeBlock(new BlockPos(x, y, z)));
                }
            }
        }
        return new Object[]{list.toArray()};
    }

    private synchronized Object[] setBlock(BlockPos worldPosition, String material, int metadata) {
        switch (this.getBlock(worldPosition)) {
            case "air": {
                if (this.func_174877_v().func_185332_f(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()) > 32.0) {
                    return new Object[]{false, "block out of range"};
                }
                if (this.getFogBlocks().size() == 256) {
                    return new Object[]{false, "block limit reached"};
                }
                return new Object[]{this.consumeBuildEnergy() && this.consumeMaterial() && this.setShieldBlock(worldPosition, material, metadata).equals("nanoFog")};
            }
            case "nanoFog": {
                return new Object[]{this.updateShieldBlock(worldPosition, material, metadata).equals("nanoFog")};
            }
        }
        return new Object[]{false, "target block is not air"};
    }

    @Callback(doc="function(int x, int y, int z):boolean; set a fog block to solid", direct=true)
    public synchronized Object[] setSolid(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false};
        }
        fog.setSolid(true);
        return new Object[]{true};
    }

    @Callback(doc="function(int x, int y, int z):boolean; set a fog block to shield", direct=true)
    public synchronized Object[] setShield(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false};
        }
        fog.setSolid(false);
        return new Object[]{true};
    }

    @Callback(doc="function(int x, int y, int z, int power):boolean; set knockback power [0, 1, 2]", direct=true)
    public synchronized Object[] setKnockback(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false};
        }
        int knockback = args.checkInteger(3);
        if (knockback < 0) {
            knockback = 0;
        }
        if (knockback > 2) {
            knockback = 2;
        }
        fog.setKnockback(knockback);
        return new Object[]{true};
    }

    @Callback(doc="function(int x, int y, int z, int power):boolean; set damage power [0 - 5]", direct=true)
    public synchronized Object[] setDamage(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false};
        }
        int damage = args.checkInteger(3);
        if (damage < 0) {
            damage = 0;
        }
        if (damage > 5) {
            damage = 5;
        }
        fog.setDamage(damage);
        return new Object[]{true};
    }

    @Callback(doc="function():array; displays a list of all available entities", direct=true)
    public Object[] getEntityClassNames(Context context, Arguments args) {
        HashSet<String> entities = new HashSet<String>();
        for (Class<? extends Entity> c : ClassHelper.getEntityList()) {
            entities.add(c.getSimpleName());
        }
        return new Object[]{entities.toArray()};
    }

    @Callback(doc="function(int x, int y, int z, string type/class, boolean passEntity, [boolean damageEntity (false) , string name (\"\")]):boolean; sets fog filter", direct=true)
    public synchronized Object[] setFilter(Context context, Arguments args) {
        Class<EntityPlayer> clazz;
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false};
        }
        String filterType = args.checkString(3).toLowerCase();
        boolean allowPass = args.checkBoolean(4);
        boolean damageEntity = args.count() >= 6 && args.checkBoolean(5);
        String name = args.count() >= 7 ? args.checkString(6) : "";
        switch (filterType) {
            case "player": {
                clazz = EntityPlayer.class;
                break;
            }
            case "hostile": {
                clazz = EntityMob.class;
                break;
            }
            case "animal": {
                clazz = EntityAnimal.class;
                break;
            }
            case "item": {
                clazz = EntityItem.class;
                break;
            }
            case "all": {
                clazz = Entity.class;
                break;
            }
            default: {
                clazz = Entity.class;
                for (Class<? extends Entity> c : ClassHelper.getEntityList()) {
                    if (!c.getSimpleName().toLowerCase().equals(filterType.toLowerCase())) continue;
                    clazz = c;
                }
            }
        }
        if (allowPass) {
            fog.filterPass.add(clazz, name);
        } else {
            fog.filterPass.remove(clazz, name);
        }
        if (damageEntity) {
            fog.filterDamage.add(clazz, name);
        } else {
            fog.filterDamage.remove(clazz, name);
        }
        fog.markDirtyClient();
        return new Object[]{true};
    }

    @Callback(doc="function(int x, int y, int z):array; get pass filter", direct=true)
    public Object[] getFilterPass(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false, "no fog block"};
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Map.Entry<String, HashSet<String>> entry : fog.filterPass.getList().entrySet()) {
            list.add(new Object[]{entry.getKey(), entry.getValue().toArray()});
        }
        return list.toArray();
    }

    @Callback(doc="function(int x, int y, int z):array; get damage filter", direct=true)
    public Object[] getFilterDamage(Context context, Arguments args) {
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false, "no fog block"};
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Map.Entry<String, HashSet<String>> entry : fog.filterDamage.getList().entrySet()) {
            list.add(new Object[]{entry.getKey(), entry.getValue().toArray()});
        }
        return list.toArray();
    }

    @Callback(doc="function(int x, int y, int z):string; get block type", direct=true)
    public Object[] get(Context context, Arguments args) {
        if (args.count() < 3) {
            return new Object[]{"not enough arguments"};
        }
        return new Object[]{this.getFog(this.getPos(args)) != null ? "nanoFog" : "unknown"};
    }

    @Callback(doc="function(int x, int y, int z):boolean; disassemble fog block", direct=false)
    public synchronized Object[] reset(Context context, Arguments args) {
        if (args.count() < 3) {
            return new Object[]{false, "not enough arguments"};
        }
        TileEntityNanoFog fog = this.getFog(this.getPos(args));
        if (fog == null) {
            return new Object[]{false, "not a fog block"};
        }
        this.removeBlock(this.getPos(args));
        return new Object[]{this.getFog(this.getPos(args)) == null};
    }

    @Callback(doc="function():boolean; disassembles all fog blocks", direct=false)
    public synchronized Object[] resetAll(Context context, Arguments args) {
        this.resetAllBlocks();
        return new Object[]{this.getFogBlocks().size() == 0};
    }

    void resetAllBlocks() {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>(this.getFogBlocks());
        for (BlockPos pos : blocks) {
            this.removeBlock(pos);
        }
    }

    public boolean consumeKnockbackEnergy(int knockbackPower) {
        return this.node.tryChangeBuffer((double)(-2 * knockbackPower));
    }

    public boolean consumeDamageEnergy(int damagePower) {
        return this.node.tryChangeBuffer((double)(-5 * damagePower));
    }

    private boolean consumeMaterial() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)ItemNanoDNA.DEFAULTSTACK) && stack.func_190916_E() > 0) {
            stack.func_190918_g(1);
            this.inventory.setStackInSlot(0, stack);
            return true;
        }
        return false;
    }

    private boolean consumeUpkeepEnergy() {
        return this.node.tryChangeBuffer((double)(-1 * this.getFogBlocks().size()));
    }

    public boolean consumeBuildEnergy() {
        return this.node.tryChangeBuffer(-50.0);
    }

    private void updateEnergyBufferSize() {
        this.node.setLocalBufferSize((double)(4096 + 10 * this.getFogBlocks().size()));
    }

    private String setShieldBlock(BlockPos pos, String material, int metadata) {
        this.placeBlock(pos, new ItemStack((Block)BlockNanoFog.DEFAULTITEM, 1));
        this.updateEnergyBufferSize();
        TileEntityNanoFog te = (TileEntityNanoFog)this.func_145831_w().func_175625_s(pos);
        if (te == null) {
            return this.getBlock(pos);
        }
        if (Config.getConfig().getCategory("general").get("instantNanoFog").getBoolean()) {
            te.isBuild = true;
        } else {
            EntityNanoFogSwarm entity = new EntityNanoFogSwarm(this.field_145850_b);
            entity.setTravelToFogBlock(this.func_174877_v(), pos);
            this.func_145831_w().func_72838_d((Entity)entity);
        }
        te.setTerminalLocation(this.func_174877_v());
        this.func_70296_d();
        this.updateShieldBlock(pos, material, metadata);
        return this.getBlock(pos);
    }

    @Deprecated
    private String updateShieldBlock(BlockPos pos, String material, int metadata) {
        TileEntityNanoFog te = (TileEntityNanoFog)this.func_145831_w().func_175625_s(pos);
        te.setCamoBlock(Block.func_149684_b((String)material), metadata);
        return this.getBlock(pos);
    }

    TileEntityNanoFog getFog(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        return te instanceof TileEntityNanoFog ? (TileEntityNanoFog)te : null;
    }

    BlockPos getPos(Arguments args) {
        return this.getPos(args, 0);
    }

    BlockPos getPos(Arguments args, int offset) {
        if (args.count() < 3 + offset) {
            return null;
        }
        int x = args.checkInteger(0 + offset);
        int y = args.checkInteger(1 + offset);
        int z = args.checkInteger(2 + offset);
        return new BlockPos(x, y, z).func_177971_a((Vec3i)this.func_174877_v());
    }

    public boolean returnFogMaterial(ItemStack outputStack) {
        if (outputStack.func_190926_b()) {
            return false;
        }
        ItemStack inventoryInputStack = this.inventory.getStackInSlot(0);
        if (inventoryInputStack.func_190916_E() == 0) {
            this.inventory.setStackInSlot(0, outputStack);
            return true;
        }
        if (inventoryInputStack.func_190916_E() < 64) {
            outputStack.func_190917_f(inventoryInputStack.func_190916_E());
            this.inventory.setStackInSlot(0, outputStack);
            return true;
        }
        ItemStack inventoryOutputStack = this.inventory.getStackInSlot(1);
        if (inventoryOutputStack.func_190916_E() == 0) {
            this.inventory.setStackInSlot(1, outputStack);
            return true;
        }
        if (inventoryOutputStack.func_190916_E() < 64) {
            outputStack.func_190917_f(inventoryOutputStack.func_190916_E());
            this.inventory.setStackInSlot(1, outputStack);
            return true;
        }
        ItemUtils.dropItem(outputStack, this.func_145831_w(), this.func_174877_v(), false, 10);
        return true;
    }

    boolean removeBlock(BlockPos pos) {
        if (!this.fogBlocks.contains(pos)) {
            return false;
        }
        this.fogBlocks.remove(pos);
        if (Config.getConfig().getCategory("general").get("instantNanoFog").getBoolean()) {
            this.getFog(pos).notifyRemove();
        } else {
            EntityNanoFogSwarm entity = new EntityNanoFogSwarm(this.field_145850_b);
            entity.setTravelToTerminal(pos, this.func_174877_v());
            this.func_145831_w().func_72838_d((Entity)entity);
        }
        this.updateEnergyBufferSize();
        this.func_70296_d();
        return true;
    }

    String getBlock(BlockPos pos) {
        if (this.func_145831_w().func_175623_d(pos)) {
            return "air";
        }
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        return te instanceof TileEntityNanoFog ? "nanoFog" : te.getClass().toString();
    }

    public boolean placeBlock(BlockPos pos, ItemStack consumedStack) {
        if (this.func_145831_w().field_72995_K) {
            return false;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = new FakePlayer(DimensionManager.getWorld((int)this.func_145831_w().field_73011_w.getDimension()), new GameProfile(UUID.randomUUID(), this.getComponentName()));
        }
        IBlockState state = BlockUtils.placeStackAt((EntityPlayer)this.fakePlayer, consumedStack, this.func_145831_w(), pos, null);
        if (this.func_145831_w().func_180495_p(pos).equals(state) || this.func_145831_w().func_180501_a(pos, state, 3)) {
            this.fogBlocks.add(pos);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.deserializeNBT(data.func_74775_l("invIn"));
        this.fogBlocks.clear();
        int shieldBlock = 0;
        while (data.func_74764_b("sB" + shieldBlock)) {
            this.fogBlocks.add(NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l("sB" + shieldBlock)));
            ++shieldBlock;
        }
        shieldBlock = 0;
        while (data.func_74764_b("sBX" + shieldBlock)) {
            this.fogBlocks.add(new BlockPos(data.func_74762_e("sBX" + shieldBlock), data.func_74762_e("sBY" + shieldBlock), data.func_74762_e("sBZ" + shieldBlock)));
            ++shieldBlock;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74782_a("invIn", (NBTBase)this.inventory.serializeNBT());
        int shieldBlock = 0;
        for (BlockPos pos : this.fogBlocks) {
            data.func_74782_a("sB" + shieldBlock, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            ++shieldBlock;
        }
        return data;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }
}

