/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import com.google.common.hash.Hashing;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import li.cil.oc.Settings;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mindrot.jbcrypt.BCrypt;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntityDataBlock
extends TileEntityOSBase {
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();

    public TileEntityDataBlock() {
        super("os_datablock");
        if (this.node() != null) {
            this.initOCFilesystem("/lua/datablock/", "datablock");
        }
    }

    @Override
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            node.connect(this.oc_fs().node());
        }
    }

    @Override
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs().node());
        } else if (node == this.node) {
            this.oc_fs().node().remove();
        }
    }

    @Callback(direct=true, doc="function():number -- The maximum size of data that can be passed to other functions of the card.")
    public Object[] getLimit(Context context, Arguments args) {
        return new Object[]{Settings.get().dataCardHardLimit()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies base64 encoding to the data.")
    public Object[] encode64(Context context, Arguments args) throws Exception {
        return new Object[]{Base64.encodeBase64((byte[])this.checkLimits(context, args, Settings.get().dataCardComplex()))};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies base64 decoding to the data.")
    public Object[] decode64(Context context, Arguments args) throws Exception {
        return new Object[]{Base64.decodeBase64((byte[])this.checkLimits(context, args, Settings.get().dataCardComplex()))};
    }

    @Callback(direct=true, limit=6, doc="function(data:string):string -- Applies deflate compression to the data.")
    public Object[] deflate(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardComplex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DeflaterOutputStream deos = new DeflaterOutputStream((OutputStream)baos);
        deos.write(data);
        deos.finish();
        deos.close();
        return new Object[]{baos.toByteArray()};
    }

    @Callback(direct=true, limit=6, doc="function(data:string):string -- Applies inflate decompression to the data.")
    public Object[] inflate(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardComplex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        InflaterOutputStream inos = new InflaterOutputStream((OutputStream)baos);
        inos.write(data);
        inos.finish();
        inos.close();
        return new Object[]{baos.toByteArray()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Computes SHA2-256 hash of the data. Result is in binary format.")
    public Object[] sha256(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.sha256().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- function(data:string):string -- Computes MD5 hash of the data. Result is in binary format")
    public Object[] md5(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.md5().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Computes CRC-32 hash of the data. Result is in binary format")
    public Object[] crc32(Context context, Arguments args) throws Exception {
        byte[] data = this.checkLimits(context, args, Settings.get().dataCardSimple());
        return new Object[]{Hashing.crc32().hashBytes(data).asBytes()};
    }

    @Callback(direct=true, limit=32, doc="function(data:string):string -- Applies rot13 to the data. ")
    public Object[] rot13(Context context, Arguments args) {
        return new Object[]{TileEntityDataBlock.rot13(args.checkString(0))};
    }

    @Callback(direct=true, limit=32, doc="function(plain-text:string, optional rounds:int):string -- Computes the bCryptHash of the input plaintext, optionally supply rounds (4-15)")
    public Object[] bCryptHash(Context context, Arguments args) {
        int rounds = (int)args.optDouble(1, 10.0);
        if (rounds < 4) {
            rounds = 4;
        } else if (rounds > 15) {
            rounds = 15;
        }
        String hashed = BCrypt.hashpw((String)args.checkString(0), (String)BCrypt.gensalt((int)rounds));
        return new Object[]{hashed};
    }

    @Callback(direct=true, limit=32, doc="function(plain-text:string, hash:string):boolean -- Checks bCrypt input vs hash supplied")
    public Object[] bCryptCheck(Context context, Arguments args) {
        return new Object[]{BCrypt.checkpw((String)args.checkString(0), (String)args.checkString(1))};
    }

    private byte[] checkLimits(Context context, Arguments args, Double cost) throws Exception {
        byte[] data = args.checkByteArray(0);
        if (data.length > Settings.get().dataCardHardLimit()) {
            throw new IllegalArgumentException("data size limit exceeded");
        }
        if (!this.node.tryChangeBuffer(-cost.doubleValue())) {
            throw new Exception("not enough energy");
        }
        if (data.length > Settings.get().dataCardSoftLimit()) {
            context.pause(Settings.get().dataCardTimeout());
        }
        return data;
    }

    public static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

