/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.models;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.client.models.ModelCube;
import pcl.opensecurity.common.entity.EntityNanoFogSwarm;

@SideOnly(value=Side.CLIENT)
public abstract class ModelNanoFogSwarm
extends ModelBase {
    public static int resolution = 8;
    static double resolutionOffset = 1.0 / (double)resolution / 2.0;

    public static void setupResolution(int res) {
        resolution = res;
        resolutionOffset = 1.0 / (double)resolution / 2.0;
    }

    static float interpolate(float current, float max) {
        return 1.0f / max * Math.min(current, max);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityNanoFogSwarm entity, float partialTicks, float scale) {
        float cubeScaleFactor = this.getCubeScaleFactor(entity);
        float cubeOffsetFactor = this.getCubeOffsetFactor(entity);
        GlStateManager.func_179137_b((double)resolutionOffset, (double)(resolutionOffset + 0.5), (double)resolutionOffset);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)this.getAlpha(entity));
        GlStateManager.func_179152_a((float)(scale *= this.getEntityScaleFactor(entity)), (float)scale, (float)scale);
        for (EntityNanoFogSwarm.Cube cube : entity.cubes) {
            cube.render(partialTicks, cubeScaleFactor, cubeOffsetFactor);
        }
    }

    abstract float getCubeScaleFactor(EntityNanoFogSwarm var1);

    abstract float getAlpha(EntityNanoFogSwarm var1);

    abstract float getEntityScaleFactor(EntityNanoFogSwarm var1);

    abstract float getCubeOffsetFactor(EntityNanoFogSwarm var1);

    public static void drawCube(float scale) {
        ModelCube.drawCube(-(scale /= 2.0f), -scale, -scale, scale, scale, scale);
    }
}

