/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.railroad;

import cassiokf.industrialrenewal.blocks.railroad.BlockRailFacing;
import cassiokf.industrialrenewal.entity.EntityTenderBase;
import cassiokf.industrialrenewal.entity.LocomotiveBase;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityBaseLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityCargoLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityFluidLoader;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityLoaderRail
extends TEBase {
    public void onMinecartPass(EntityMinecart ecart) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.GetCartInvType(this.field_145850_b, this.field_174879_c, state, ecart) == 0) {
            BlockRailFacing.propelMinecart(state, ecart);
        } else {
            this.informLoader(state, ecart);
        }
    }

    private void informLoader(IBlockState state, EntityMinecart ecart) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockRailFacing.FACING);
        TileEntity leftTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176735_f()));
        TileEntity rightTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176746_e()));
        if (leftTE instanceof TileEntityBaseLoader || rightTE instanceof TileEntityBaseLoader) {
            TileEntityBaseLoader teLoader;
            TileEntityBaseLoader tileEntityBaseLoader = teLoader = leftTE instanceof TileEntityBaseLoader ? (TileEntityBaseLoader)leftTE : (TileEntityBaseLoader)rightTE;
            if (teLoader.onMinecartPass(ecart, this)) {
                ecart.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
                ecart.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
                ecart.field_70159_w = 0.0;
                ecart.field_70179_y = 0.0;
            } else {
                BlockRailFacing.propelMinecart(state, ecart);
            }
        } else {
            BlockRailFacing.propelMinecart(state, ecart);
        }
    }

    private int GetCartInvType(World world, BlockPos pos, IBlockState state, EntityMinecart cart) {
        if (cart instanceof EntityTenderBase || cart instanceof LocomotiveBase) {
            return 0;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockRailFacing.FACING);
        TileEntity leftTE = world.func_175625_s(pos.func_177972_a(facing.func_176735_f()));
        TileEntity rightTE = world.func_175625_s(pos.func_177972_a(facing.func_176746_e()));
        int type = 0;
        if (cart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && (leftTE instanceof TileEntityCargoLoader || rightTE instanceof TileEntityCargoLoader)) {
            type = 1;
        } else if (cart.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (leftTE instanceof TileEntityFluidLoader || rightTE instanceof TileEntityFluidLoader)) {
            type = 2;
        }
        return type;
    }
}

