/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.machines;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.recipes.LatheRecipe;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TELathe
extends TileEntityMultiBlockBase<TELathe> {
    private static final int energyPTick = IRConfig.MainConfig.Main.energyPerTickLatheMachine;
    private static final float volume = 0.2f * IRConfig.MainConfig.Sounds.masterVolumeMult;
    private final VoltsEnergyContainer energyContainer;
    private final ItemStackHandler input;
    private final ItemStackHandler outPut;
    public boolean inProcess = false;
    private ItemStack hold = ItemStack.field_190927_a;
    private boolean oldInProcess;
    private int tick;
    private int processTime;
    private float renderCutterProcess;
    private float oldProcessTime;
    private ItemStack processingItem;
    private boolean stopping = false;
    private boolean stopped = true;
    private boolean oldStopping = false;

    public TELathe() {
        this.energyContainer = new VoltsEnergyContainer(10240, 256, 256){

            @Override
            public void onEnergyChange() {
                if (!((TELathe)TELathe.this).field_145850_b.field_72995_K) {
                    TELathe.this.sync();
                }
            }
        };
        this.input = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TELathe.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return LatheRecipe.CACHED_RECIPES.containsKey(stack.func_77973_b());
            }
        };
        this.outPut = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TELathe.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    @Override
    public void onTick() {
        if (this.isMaster()) {
            ItemStack inputStack = this.input.getStackInSlot(0);
            this.oldProcessTime = this.renderCutterProcess;
            if (!this.inProcess && !inputStack.func_190926_b() && LatheRecipe.CACHED_RECIPES.containsKey(inputStack.func_77973_b())) {
                this.getProcessFromInputItem(inputStack);
            } else if (this.inProcess) {
                this.process();
            }
            if (!this.inProcess && !this.oldInProcess) {
                this.stopping = true;
            }
            this.oldInProcess = this.inProcess;
            this.renderCutterProcess = this.processTime > 0 ? Utils.normalizeClamped(this.tick, 0.0f, this.processTime) * 0.8f : 0.0f;
            this.tryOutPutItem();
            this.handleSound();
        }
    }

    private void handleSound() {
        if (!this.inProcess && this.stopping && !this.stopped) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, IRSoundRegister.LATHE_STOP, SoundCategory.BLOCKS, volume, 1.0f);
            }
            this.stopping = false;
            this.stopped = true;
            this.oldStopping = false;
            this.sync();
        } else if (this.inProcess) {
            this.stopped = false;
            if (this.field_145850_b.field_72995_K) {
                IRSoundHandler.playRepeatableSound(IRSoundRegister.LATHE_RESOURCEL, volume, 1.0f, this.field_174879_c);
            }
        } else {
            if (this.field_145850_b.field_72995_K) {
                IRSoundHandler.stopTileSound(this.field_174879_c);
            }
            this.stopping = false;
            if (this.oldStopping) {
                this.oldStopping = false;
                this.sync();
            }
        }
    }

    private void process() {
        if (this.energyContainer.getEnergyStored() < energyPTick) {
            return;
        }
        this.energyContainer.extractEnergy(energyPTick, false);
        ++this.tick;
        if (this.tick >= this.processTime) {
            this.tick = 0;
            this.processTime = 0;
            this.inProcess = false;
            this.processingItem = null;
            if (!this.field_145850_b.field_72995_K) {
                this.outPut.insertItem(0, this.hold, false);
            }
        }
    }

    private void getProcessFromInputItem(ItemStack inputStack) {
        ItemStack result;
        LatheRecipe recipe = LatheRecipe.CACHED_RECIPES.get(inputStack.func_77973_b());
        if (recipe != null && (result = recipe.func_77571_b()) != null && !result.func_190926_b() && this.outPut.insertItem(0, result, true).func_190926_b() && this.energyContainer.getEnergyStored() >= energyPTick) {
            this.processTime = recipe.getProcessTime();
            this.inProcess = true;
            this.processingItem = inputStack;
            if (!this.field_145850_b.field_72995_K) {
                inputStack.func_190918_g(recipe.getInput().get(0).func_190916_E());
            }
            this.hold = result;
        }
    }

    private void tryOutPutItem() {
        IItemHandler outputCap;
        EnumFacing facing;
        TileEntity te;
        if (!this.field_145850_b.field_72995_K && !this.outPut.getStackInSlot(0).func_190926_b() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing = this.getMasterFacing().func_176746_e(), 2))) != null && (outputCap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            Utils.moveItemsBetweenInventories((IItemHandler)this.outPut, outputCap);
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TELathe;
    }

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x2x2Centered(centerPosition, this.getMasterFacing());
    }

    public IItemHandler getInputInv() {
        return this.input;
    }

    public IItemHandler getOutputInv() {
        return this.outPut;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyContainer;
    }

    public ItemStack getResultItem() {
        return this.hold;
    }

    public ItemStack getProcessingItem() {
        return this.processingItem;
    }

    public float getNormalizedProcess() {
        return this.renderCutterProcess;
    }

    public float getOldProcess() {
        return this.oldProcessTime;
    }

    @Override
    public void onMasterBreak() {
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c.func_177972_a(this.getMasterFacing().func_176735_f()), this.input);
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c.func_177972_a(this.getMasterFacing().func_176746_e()), this.outPut);
        super.onMasterBreak();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TELathe masterTE = (TELathe)this.getMaster();
        if (masterTE == null || facing == null) {
            return (T)super.getCapability(capability, facing);
        }
        if (capability.equals((Object)CapabilityEnergy.ENERGY) && facing.equals((Object)this.getMasterFacing()) && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177972_a(this.getMasterFacing()).func_177972_a(this.getMasterFacing().func_176735_f()))) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)masterTE.energyContainer);
        }
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (facing.equals((Object)this.getMasterFacing().func_176735_f()) && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177972_a(this.getMasterFacing().func_176735_f()))) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)masterTE.input);
            }
            if (facing.equals((Object)this.getMasterFacing().func_176746_e()) && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177972_a(this.getMasterFacing().func_176746_e()))) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)masterTE.outPut);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        compound.func_74782_a("output", (NBTBase)this.outPut.serializeNBT());
        compound.func_74782_a("hold", (NBTBase)this.hold.serializeNBT());
        compound.func_74782_a("StoredIR", (NBTBase)this.energyContainer.serializeNBT());
        compound.func_74757_a("processing", this.inProcess);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.input.deserializeNBT(compound.func_74775_l("input"));
        this.outPut.deserializeNBT(compound.func_74775_l("output"));
        this.hold.deserializeNBT(compound.func_74775_l("hold"));
        this.energyContainer.deserializeNBT(compound.func_74775_l("StoredIR"));
        this.inProcess = compound.func_74767_n("processing");
        super.func_145839_a(compound);
    }
}

