/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.machines;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.abstracts.TEMultiTankBase;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TEIndustrialBatteryBank
extends TEMultiTankBase<TEIndustrialBatteryBank> {
    public static final int capacity = IRConfig.MainConfig.Main.lithiumBatteryCapacity;
    private static final int maxTransfer = IRConfig.MainConfig.Main.industrialBatteryBankMaxTransfer;
    private static final int maxBatteries = 24;
    private final VoltsEnergyContainer energyContainer = new VoltsEnergyContainer(1, maxTransfer, maxTransfer){

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public void onEnergyChange() {
            TEIndustrialBatteryBank.this.sync();
        }
    };
    private int input;
    private int avrIn;
    private int oldIn;
    private int outPut;
    private int avrOut;
    private int oldOutPut;
    private int batteries = 0;
    private final VoltsEnergyContainer inEnergy = new VoltsEnergyContainer(){

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ((TEIndustrialBatteryBank)TEIndustrialBatteryBank.this.getBottomTE()).onEnergyIn(maxReceive, simulate);
        }
    };
    private int tick;

    public int onEnergyIn(int maxReceive, boolean simulate) {
        int in;
        maxReceive = Math.min(maxReceive, maxTransfer);
        if (this.batteries > 0) {
            in = this.energyContainer.receiveInternally(maxReceive, simulate);
        } else {
            in = this.outPutEnergy(null, maxReceive, simulate);
            if (!simulate && !this.field_145850_b.field_72995_K) {
                this.outPut += in;
            }
        }
        if (!simulate && !this.field_145850_b.field_72995_K) {
            this.input += in;
        }
        return in;
    }

    public boolean placeBattery(EntityPlayer player, ItemStack batteryStack) {
        if (this.batteries >= 24) {
            return false;
        }
        ++this.batteries;
        if (!this.field_145850_b.field_72995_K) {
            if (!player.func_184812_l_()) {
                batteryStack.func_190918_g(1);
            }
            this.reachTop();
        }
        return true;
    }

    @Override
    public void onTick() {
        if (!this.field_145850_b.field_72995_K && this.isMaster() && this.isBottom()) {
            if (this.batteries > 0 && this.energyContainer.getEnergyStored() > 0) {
                this.outPut += this.outPutEnergy(this.energyContainer, maxTransfer, false);
            }
            if (this.tick >= 10) {
                this.tick = 0;
                this.avrIn = this.input / 10;
                this.avrOut = this.outPut / 10;
                this.input = 0;
                this.outPut = 0;
                if (this.avrOut != this.oldOutPut || this.avrIn != this.oldIn) {
                    this.oldOutPut = this.avrOut;
                    this.oldIn = this.avrIn;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    private int outPutEnergy(VoltsEnergyContainer container, int maxReceive, boolean simulate) {
        IEnergyStorage energyStorage;
        TileEntity te = this.field_145850_b.func_175625_s(this.getOutPutPos());
        int out = 0;
        if (te != null && (energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) != null) {
            out = container == null ? energyStorage.receiveEnergy(maxReceive, simulate) : container.extractEnergyInternally(energyStorage.receiveEnergy(container.extractEnergyInternally(maxReceive, true), simulate), simulate);
        }
        return out;
    }

    @Override
    public void onMasterBreak() {
        super.onMasterBreak();
        if (this.batteries <= 0) {
            return;
        }
        ItemStack stack = new ItemStack((Item)ModItems.battery_lithium, this.batteries);
        for (int i = 0; i <= this.batteries; ++i) {
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, stack);
        }
    }

    private BlockPos getOutPutPos() {
        return ((TEIndustrialBatteryBank)this.getTopTE()).field_174879_c.func_177981_b(2).func_177972_a(this.getMasterFacing().func_176746_e());
    }

    @Override
    public void setSize(int i) {
        int realCapacity = 0;
        for (TEIndustrialBatteryBank te : ((TEIndustrialBatteryBank)this.topTE).machines) {
            realCapacity += te.getRealCapacity();
        }
        if (realCapacity <= -1) {
            realCapacity = Integer.MAX_VALUE;
        }
        this.energyContainer.setMaxEnergyStored(MathHelper.func_76125_a((int)realCapacity, (int)0, (int)Integer.MAX_VALUE));
        this.sync();
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TEIndustrialBatteryBank;
    }

    public int getRealCapacity() {
        return capacity * this.batteries;
    }

    public int getBatteries() {
        return this.batteries;
    }

    public String getEnergyText() {
        return Utils.formatEnergyString(this.energyContainer.getEnergyStored()).replace(" FE", "") + " / " + Utils.formatEnergyString(this.energyContainer.getMaxEnergyStored());
    }

    public float getBatteryFill() {
        return Utils.normalizeClamped(this.energyContainer.getEnergyStored(), 0.0f, this.energyContainer.getMaxEnergyStored());
    }

    public float getOutPutAngle() {
        return Utils.normalizeClamped(this.avrOut, 0.0f, 10240.0f) * 90.0f;
    }

    public String getOutPutText() {
        return Utils.formatPreciseEnergyString(this.avrOut) + "/t";
    }

    public float getInPutAngle() {
        return Utils.normalizeClamped(this.avrIn, 0.0f, 10240.0f) * 90.0f;
    }

    public String getInPutText() {
        return Utils.formatPreciseEnergyString(this.avrIn) + "/t";
    }

    public String getInPutIndicatorText() {
        return TextFormatting.BLACK + I18n.func_135052_a((String)"tesr.indr.in", (Object[])new Object[0]);
    }

    public String getOutPutIndicatorText() {
        return TextFormatting.BLACK + I18n.func_135052_a((String)"tesr.indr.out", (Object[])new Object[0]);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == EnumFacing.UP) {
            EnumFacing face = this.getMasterFacing();
            if (this.field_174879_c.equals((Object)((TEIndustrialBatteryBank)this.getMaster()).field_174879_c.func_177984_a().func_177972_a(face.func_176746_e()))) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)((TEIndustrialBatteryBank)this.getMaster()).energyContainer);
            }
            if (this.field_174879_c.equals((Object)((TEIndustrialBatteryBank)this.getMaster()).field_174879_c.func_177984_a().func_177972_a(face.func_176735_f()))) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)((TEIndustrialBatteryBank)this.getMaster()).inEnergy);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.energyContainer.serializeNBT(compound);
        compound.func_74768_a("out", this.avrOut);
        compound.func_74768_a("in", this.avrIn);
        compound.func_74768_a("battery", this.batteries);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.energyContainer.deserializeNBT(compound);
        this.avrOut = compound.func_74762_e("out");
        this.avrIn = compound.func_74762_e("in");
        this.batteries = compound.func_74762_e("battery");
        super.func_145839_a(compound);
    }
}

