/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.pipes.BlockHVConnectorBase;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.IConnectorHV;
import java.util.ArrayList;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHVConnectorBase
extends TileEntitySync {
    public BlockPos leftConnectionPos = null;
    public BlockPos rightConnectionPos = null;
    private boolean leftConnected;
    private boolean rightConnected;
    private TileEntityHVConnectorBase master;
    private boolean isMaster;

    private void initializeNetworkIfNecessary() {
        if (this.master == null || this.master.func_145837_r()) {
            ArrayList<TileEntityHVConnectorBase> connectedCables = new ArrayList<TileEntityHVConnectorBase>();
            Stack<TileEntityHVConnectorBase> traversingCables = new Stack<TileEntityHVConnectorBase>();
            IConnectorHV inTransformerT = null;
            IConnectorHV outTransformerT = null;
            TileEntityHVConnectorBase master = this;
            traversingCables.add(this);
            while (!traversingCables.isEmpty()) {
                TileEntity te;
                TileEntityHVConnectorBase storage = (TileEntityHVConnectorBase)traversingCables.pop();
                if (storage.isMaster()) {
                    master = storage;
                }
                connectedCables.add(storage);
                if (storage.isLeftConnected()) {
                    te = this.field_145850_b.func_175625_s(storage.leftConnectionPos);
                    if (te instanceof TileEntityHVConnectorBase && !connectedCables.contains(te)) {
                        traversingCables.add((TileEntityHVConnectorBase)te);
                    }
                    if (te instanceof IConnectorHV) {
                        if (((IConnectorHV)te).isOutput()) {
                            outTransformerT = (IConnectorHV)te;
                        } else {
                            inTransformerT = (IConnectorHV)te;
                        }
                    }
                }
                if (!storage.isRightConnected()) continue;
                te = this.field_145850_b.func_175625_s(storage.rightConnectionPos);
                if (te instanceof TileEntityHVConnectorBase && !connectedCables.contains(te)) {
                    traversingCables.add((TileEntityHVConnectorBase)te);
                }
                if (!(te instanceof IConnectorHV)) continue;
                ((IConnectorHV)te).setOtherSideTransformer(null);
                if (((IConnectorHV)te).isOutput()) {
                    outTransformerT = (IConnectorHV)te;
                    continue;
                }
                inTransformerT = (IConnectorHV)te;
            }
            for (TileEntityHVConnectorBase storage : connectedCables) {
                storage.setMaster(master);
                storage.func_70296_d();
            }
            if (inTransformerT != null) {
                inTransformerT.setOtherSideTransformer(outTransformerT);
            }
            if (outTransformerT != null) {
                outTransformerT.setOtherSideTransformer(inTransformerT);
            }
            master.func_70296_d();
            this.func_70296_d();
        }
    }

    public void forceRecheck() {
        this.master = null;
        this.initializeNetworkIfNecessary();
    }

    public void removeCableAndSpawn(BlockPos connectionPos) {
        this.disableConnectedCables(connectionPos);
        this.removeConnection(connectionPos);
        if (!this.field_145850_b.field_72995_K) {
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, new ItemStack((Item)ModItems.coilHV));
        }
    }

    private void disableConnectedCables(BlockPos connectedPos) {
        TileEntity te = this.field_145850_b.func_175625_s(connectedPos);
        if (te instanceof TileEntityHVConnectorBase) {
            ((TileEntityHVConnectorBase)te).removeConnection(this.field_174879_c);
        } else if (te instanceof IConnectorHV) {
            ((IConnectorHV)te).removeConnection();
        }
    }

    public void removeConnection(BlockPos sidePos) {
        if (sidePos.equals((Object)this.leftConnectionPos)) {
            this.leftConnected = false;
            this.leftConnectionPos = null;
            this.master = null;
            this.initializeNetworkIfNecessary();
            this.sync();
        } else if (sidePos.equals((Object)this.rightConnectionPos)) {
            this.rightConnected = false;
            this.rightConnectionPos = null;
            this.master = null;
            this.initializeNetworkIfNecessary();
            this.sync();
        }
    }

    public void removeAllConnections() {
        if (this.isRightConnected()) {
            this.removeConnection(this.rightConnectionPos);
        }
        if (this.isLeftConnected()) {
            this.removeConnection(this.leftConnectionPos);
        }
    }

    public boolean canConnect() {
        return !this.isLeftConnected() || !this.isRightConnected();
    }

    public void setConnection(BlockPos otherConnectorPos) {
        boolean madeConnection = false;
        if (!this.isLeftConnected()) {
            this.setLeftConnectionPos(otherConnectorPos);
            madeConnection = true;
        } else if (!this.isRightConnected()) {
            this.setRightConnectionPos(otherConnectorPos);
            madeConnection = true;
        }
        if (madeConnection) {
            this.master = null;
            this.initializeNetworkIfNecessary();
        }
        this.sync();
    }

    public EnumFacing getBlockFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHVConnectorBase.FACING);
    }

    private void setLeftConnectionPos(BlockPos pos) {
        this.leftConnectionPos = pos;
        this.leftConnected = true;
    }

    private void setRightConnectionPos(BlockPos pos) {
        this.rightConnectionPos = pos;
        this.rightConnected = true;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public TileEntityHVConnectorBase getMaster() {
        this.initializeNetworkIfNecessary();
        return this.master;
    }

    public void setMaster(TileEntityHVConnectorBase master) {
        this.master = master;
        this.isMaster = master == this;
        this.func_70296_d();
    }

    public boolean isLeftConnected() {
        return this.leftConnected;
    }

    public boolean isRightConnected() {
        return this.rightConnected;
    }

    @Override
    public void onBlockBreak() {
        if (this.isLeftConnected()) {
            this.removeCableAndSpawn(this.leftConnectionPos);
        }
        if (this.isRightConnected()) {
            this.removeCableAndSpawn(this.rightConnectionPos);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.rightConnectionPos = BlockPos.func_177969_a((long)compound.func_74763_f("rightP"));
        this.leftConnectionPos = BlockPos.func_177969_a((long)compound.func_74763_f("leftP"));
        this.rightConnected = compound.func_74767_n("rightCon");
        this.leftConnected = compound.func_74767_n("leftCon");
        this.isMaster = compound.func_74767_n("isMaster");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.rightConnectionPos != null) {
            compound.func_74772_a("rightP", this.rightConnectionPos.func_177986_g());
        }
        if (this.leftConnectionPos != null) {
            compound.func_74772_a("leftP", this.leftConnectionPos.func_177986_g());
        }
        compound.func_74757_a("rightCon", this.rightConnected);
        compound.func_74757_a("leftCon", this.leftConnected);
        compound.func_74757_a("isMaster", this.isMaster);
        return super.func_189515_b(compound);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

