/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockEnergyLevel;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityEnergyLevel
extends TEBase {
    private EnumFacing baseFacing = EnumFacing.DOWN;
    private EnumFacing indicatorHorizontalFacing;
    private IEnergyStorage energyStorage;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public String GetText() {
        if (this.getEnergyStorage() != null) {
            int energy = this.energyStorage.getEnergyStored();
            String text = energy + "";
            if (energy >= 1000 && energy < 1000000) {
                text = energy / 1000 + "K";
            }
            if (energy >= 1000000) {
                text = energy / 1000000 + "M";
            }
            int energy2 = this.energyStorage.getMaxEnergyStored();
            String textM = energy2 + " FE";
            if (energy >= 1000 && energy2 < 1000000) {
                textM = energy2 / 1000 + "K FE";
            }
            if (energy2 >= 1000000) {
                textM = energy2 / 1000000 + "M FE";
            }
            return text + " / " + textM;
        }
        return "No Battery";
    }

    public EnumFacing getBaseFacing() {
        return this.baseFacing;
    }

    public void setBaseFacing(EnumFacing facing) {
        this.baseFacing = facing;
        this.func_70296_d();
    }

    public EnumFacing getGaugeFacing() {
        if (this.indicatorHorizontalFacing != null) {
            return this.indicatorHorizontalFacing;
        }
        return this.forceIndicatorCheck();
    }

    public EnumFacing forceIndicatorCheck() {
        this.indicatorHorizontalFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyLevel.FACING);
        return this.indicatorHorizontalFacing;
    }

    public float GetTankFill() {
        if (this.getEnergyStorage() != null) {
            float currentAmount = this.energyStorage.getEnergyStored();
            float totalCapacity = this.energyStorage.getMaxEnergyStored();
            return currentAmount /= totalCapacity;
        }
        return 0.0f;
    }

    private IEnergyStorage getEnergyStorage() {
        if (this.energyStorage != null) {
            return this.energyStorage;
        }
        return this.forceCheck();
    }

    public IEnergyStorage forceCheck() {
        IEnergyStorage handler;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.baseFacing));
        if (te != null && (handler = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.baseFacing.func_176734_d())) != null) {
            this.energyStorage = handler;
            return this.energyStorage;
        }
        this.energyStorage = null;
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("baseFacing", this.baseFacing.func_176745_a());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.baseFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("baseFacing"));
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

