/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockElectricPump;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityElectricPump
extends TileEntitySync
implements ITickable {
    private final VoltsEnergyContainer energyContainer;
    public FluidTank tank = new FluidTank(1000){

        public boolean canFill() {
            return false;
        }

        protected void onContentsChanged() {
            TileEntityElectricPump.this.func_70296_d();
        }
    };
    private int index = -1;
    private final int everyXtick = 10;
    private int tick;
    public static int energyPerTick = IRConfig.MainConfig.Main.pumpEnergyPerTick;
    private EnumFacing facing;
    private final float volume;
    private final List<BlockPos> fluidSet;
    private final int maxRadius;
    private boolean isRunning;
    private boolean oldIsRunning;
    private boolean starting;
    private boolean oldStarting;

    public TileEntityElectricPump() {
        this.volume = IRConfig.MainConfig.Sounds.pumpVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
        this.fluidSet = new ArrayList<BlockPos>();
        this.maxRadius = IRConfig.MainConfig.Main.maxPumpRadius;
        this.isRunning = false;
        this.oldIsRunning = false;
        this.starting = false;
        this.oldStarting = false;
        this.energyContainer = new VoltsEnergyContainer(energyPerTick * 2, energyPerTick, energyPerTick * 2){

            @Override
            public boolean canExtract() {
                return false;
            }

            @Override
            public void onEnergyChange() {
                TileEntityElectricPump.this.func_70296_d();
            }
        };
    }

    public void func_73660_a() {
        if (this.getIndex() == 1) {
            if (!this.field_145850_b.field_72995_K) {
                this.consumeEnergy();
                if (this.tick >= 10) {
                    this.tick = 0;
                    this.GetFluidDown();
                }
                ++this.tick;
                this.passFluidUp();
            }
            this.handleSound();
        }
    }

    private int getIndex() {
        if (this.index != -1) {
            return this.index;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.index = state.func_177230_c() instanceof BlockElectricPump ? (Integer)state.func_177229_b((IProperty)BlockElectricPump.INDEX) : -1;
        return this.index;
    }

    private void handleSound() {
        if (this.isRunning && !this.starting) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, IRSoundRegister.PUMP_START, SoundCategory.BLOCKS, this.volume + 0.5f, 1.0f);
            }
            this.starting = true;
            this.oldStarting = true;
            this.sync();
        } else if (this.isRunning) {
            if (this.field_145850_b.field_72995_K) {
                IRSoundHandler.playRepeatableSound(IRSoundRegister.PUMP_ROTATION_RESOURCEL, this.volume, 1.0f, this.field_174879_c);
            }
        } else {
            if (this.field_145850_b.field_72995_K) {
                IRSoundHandler.stopTileSound(this.field_174879_c);
            }
            this.starting = false;
            if (this.oldStarting) {
                this.oldStarting = false;
                this.sync();
            }
        }
    }

    private void consumeEnergy() {
        if (this.energyContainer.getEnergyStored() >= energyPerTick) {
            this.energyContainer.extractEnergyInternally(energyPerTick, false);
            this.isRunning = true;
        } else {
            this.isRunning = false;
            this.starting = false;
        }
        if (this.oldIsRunning != this.isRunning || this.oldStarting != this.starting) {
            this.oldIsRunning = this.isRunning;
            this.oldStarting = this.starting;
            this.sync();
        }
    }

    private void GetFluidDown() {
        if (this.isRunning && this.tank.getFluidAmount() <= 0) {
            if (IRConfig.MainConfig.Main.pumpInfinityWater && (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().equals(Blocks.field_150355_j) || this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().equals(Blocks.field_150358_i))) {
                this.tank.fillInternal(new FluidStack(FluidRegistry.WATER, 1000), true);
                return;
            }
            if (this.getFluidSet() != null && !this.getFluidSet().isEmpty()) {
                boolean consumeFluid;
                BlockPos fluidPos = this.getFluidSet().get(0);
                while (!this.instanceOf(fluidPos, true, null)) {
                    this.getFluidSet().remove(fluidPos);
                    if (this.getFluidSet() == null || this.getFluidSet().isEmpty()) {
                        return;
                    }
                    fluidPos = this.getFluidSet().get(0);
                }
                Block block = this.field_145850_b.func_180495_p(fluidPos).func_177230_c();
                IFluidHandler downFluid = Utils.wrapFluidBlock(block, this.field_145850_b, fluidPos);
                boolean bl = consumeFluid = downFluid.getTankProperties().length <= 0 || downFluid.getTankProperties()[0].getContents() == null || !downFluid.getTankProperties()[0].getContents().getFluid().equals(FluidRegistry.WATER) || !IRConfig.MainConfig.Main.pumpInfinityWater;
                if (this.tank.fillInternal(downFluid.drain(Integer.MAX_VALUE, false), false) > 0) {
                    FluidStack stack = downFluid.drain(Integer.MAX_VALUE, consumeFluid);
                    if (IRConfig.MainConfig.Main.replaceLavaWithCobble && stack != null && stack.getFluid().equals(FluidRegistry.LAVA)) {
                        this.field_145850_b.func_175656_a(fluidPos, Blocks.field_150347_e.func_176223_P());
                    }
                    this.tank.fillInternal(stack, true);
                }
                this.getFluidSet().remove(fluidPos);
            }
        }
    }

    private List<BlockPos> getFluidSet() {
        if (this.fluidSet.isEmpty()) {
            this.getAllFluids();
        }
        return this.fluidSet;
    }

    private void getAllFluids() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c();
        if (block instanceof BlockLiquid) {
            Stack<BlockPos> traversingFluids = new Stack<BlockPos>();
            ArrayList<BlockPos> flowingPos = new ArrayList<BlockPos>();
            traversingFluids.add(this.field_174879_c.func_177977_b());
            BlockLiquid filter = (BlockLiquid)block;
            while (!traversingFluids.isEmpty()) {
                BlockPos fluidPos = (BlockPos)traversingFluids.pop();
                if (this.instanceOf(fluidPos, true, filter)) {
                    this.fluidSet.add(fluidPos);
                } else {
                    flowingPos.add(fluidPos);
                }
                for (EnumFacing d : EnumFacing.field_82609_l) {
                    BlockPos newPos = fluidPos.func_177972_a(d);
                    if (!this.instanceOf(newPos, false, filter) || this.fluidSet.contains(newPos) || flowingPos.contains(newPos)) continue;
                    traversingFluids.add(newPos);
                }
            }
        }
    }

    private boolean instanceOf(BlockPos pos, boolean checkLevel, BlockLiquid filter) {
        if (pos == null) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return !(!(state.func_177230_c() instanceof BlockLiquid) || filter != null && state.func_177230_c() != filter || checkLevel && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !(this.field_174879_c.func_177954_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= (double)(this.maxRadius * this.maxRadius)));
    }

    private void passFluidUp() {
        IFluidHandler upTank = this.GetTankUp();
        if (upTank != null && this.tank.getFluidAmount() > 0 && upTank.fill(this.tank.drain(this.tank.getCapacity() / 10, false), false) > 0) {
            upTank.fill(this.tank.drain(this.tank.getCapacity() / 10, true), true);
        }
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
        this.starting = false;
        super.func_145843_s();
    }

    private IFluidHandler GetTankUp() {
        TileEntity upTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (upTE != null && upTE.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            return (IFluidHandler)upTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
        }
        return null;
    }

    private EnumFacing getBlockFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockElectricPump)) {
            return EnumFacing.NORTH;
        }
        this.facing = (EnumFacing)state.func_177229_b((IProperty)BlockElectricPump.FACING);
        return this.facing;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        this.tank.writeToNBT(tag);
        compound.func_74782_a("fluid", (NBTBase)tag);
        compound.func_74768_a("index", this.getIndex());
        compound.func_74757_a("isRunning", this.isRunning);
        compound.func_74757_a("starting", this.starting);
        compound.func_74782_a("StoredIR", (NBTBase)this.energyContainer.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l("fluid");
        this.tank.readFromNBT(tag);
        this.index = compound.func_74762_e("index");
        this.isRunning = compound.func_74767_n("isRunning");
        this.starting = compound.func_74767_n("starting");
        this.energyContainer.deserializeNBT(compound.func_74775_l("StoredIR"));
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityElectricPump te;
        int index = this.getIndex();
        if (index == 1 && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        EnumFacing face = this.getBlockFacing();
        if (index == 0 && capability == CapabilityEnergy.ENERGY && facing == face.func_176734_d() && (te = (TileEntityElectricPump)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face))) != null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)te.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

