/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.gui;

import cassiokf.industrialrenewal.gui.GUIBase;
import cassiokf.industrialrenewal.gui.container.ContainerStorageChest;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.NetworkHandler;
import cassiokf.industrialrenewal.network.PacketReturnTEStorageChest;
import cassiokf.industrialrenewal.tileentity.TEStorageChest;
import cassiokf.industrialrenewal.util.Utils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GUIStorageChest
extends GUIBase {
    private final TEStorageChest te;
    private GuiButton upB;
    private GuiButton downB;
    private GuiTextField searchField;
    private boolean skip;

    public GUIStorageChest(IInventory playerInv, TEStorageChest te) {
        super(new ContainerStorageChest(playerInv, te), playerInv);
        this.field_146999_f = 220;
        this.field_147000_g = 211;
        this.te = te;
    }

    protected void func_146284_a(GuiButton b) {
        this.sendToServer(b.field_146127_k);
    }

    private void sendToServer(int id) {
        this.te.guiButtonClick(id, null);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketReturnTEStorageChest(this.te, id, this.field_146297_k.field_71439_g.func_145782_y()));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int posX1 = (this.field_146294_l - this.field_146999_f) / 2;
        int posY1 = (this.field_146295_m - this.field_147000_g) / 2;
        this.upB = new GuiButton(1, posX1 + 206, posY1 + 15, 10, 18, I18n.func_135052_a((String)"gui.industrialrenewal.arrowup", (Object[])new Object[0]));
        this.downB = new GuiButton(2, posX1 + 206, posY1 + 105, 10, 18, I18n.func_135052_a((String)"gui.industrialrenewal.arrowdown", (Object[])new Object[0]));
        this.upB.field_146124_l = false;
        this.downB.field_146124_l = this.te.currentLine < this.te.additionalLines;
        this.field_146292_n.add(this.upB);
        this.field_146292_n.add(this.downB);
        Keyboard.enableRepeatEvents((boolean)true);
        FontRenderer fontRenderer = this.field_146297_k.field_71466_p;
        this.searchField = new GuiTextField(0, fontRenderer, this.field_147003_i + 138, this.field_147009_r + 5, 80, fontRenderer.field_78288_b);
        this.searchField.func_146180_a(this.te.search);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(true);
        this.searchField.func_146189_e(true);
        this.searchField.func_146195_b(this.te.searchActive);
        this.skip = false;
    }

    public void onKeyboardEvent(GuiScreenEvent.KeyboardInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            int keyCode = Keyboard.getEventKey();
            char charCode = Keyboard.getEventCharacter();
            if (this.searchField.func_146206_l()) {
                if (this.skip) {
                    this.skip = false;
                } else {
                    this.skip = true;
                    if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                        event.setCanceled(true);
                        this.skip = false;
                    } else if (keyCode == 28 || keyCode == 1) {
                        this.searchField.func_146195_b(false);
                        event.setCanceled(true);
                        this.skip = true;
                    } else {
                        for (int i = 0; i < 9; ++i) {
                            if (!this.field_146297_k.field_71474_y.field_151456_ac[i].isActiveAndMatches(keyCode)) continue;
                            event.setCanceled(true);
                            this.skip = false;
                            this.searchField.func_146201_a(charCode, keyCode);
                            return;
                        }
                    }
                    this.searchField.func_146201_a(charCode, keyCode);
                }
            } else if (this.field_146297_k.field_71474_y.field_74310_D.func_151463_i() == Keyboard.getEventKey()) {
                this.searchField.func_146195_b(true);
                this.skip = true;
            }
        }
    }

    @Override
    public String getTexturePath() {
        return "textures/gui/container/storage_chest.png";
    }

    @Override
    public String getTranslationKey() {
        return ModBlocks.storageChest.func_149739_a();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int progress = (int)((this.te.additionalLines > 0 ? Utils.normalizeClamped(this.te.currentLine, 0.0f, this.te.additionalLines) : 0.0f) * 55.0f);
        this.func_73729_b(this.field_147003_i + 207, this.field_147009_r + 34 + progress, 221, 0, 8, 15);
        this.searchField.func_146184_c(true);
        this.searchField.func_146194_f();
        this.te.search = this.searchField.func_146179_b();
        this.te.searchActive = this.searchField.func_146206_l();
        for (Slot s : this.field_147002_h.field_75151_b) {
            if (s.field_75224_c instanceof InventoryPlayer) continue;
            ItemStack stack = s.func_75211_c();
            if (this.stackMatches(this.searchField.func_146179_b(), stack)) continue;
            int x = this.field_147003_i + s.field_75223_e;
            int y = this.field_147009_r + s.field_75221_f;
            GlStateManager.func_179097_i();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-2130771968);
            GlStateManager.func_179126_j();
        }
    }

    private boolean stackMatches(String text, ItemStack stack) {
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return true;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String line : stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) {
            keys.add(line);
        }
        for (String key : keys) {
            if (!key.toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.actualMouseX = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        this.actualMouseY = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.upB.field_146124_l = this.te.currentLine > 0;
        boolean bl = this.downB.field_146124_l = this.te.currentLine < this.te.additionalLines;
        if (this.func_146978_c(205, 6, 10, 108, mouseX, mouseY)) {
            int scroll = Mouse.getDWheel();
            if (scroll > 0) {
                this.scrollPressed(true);
            } else if (scroll < 0) {
                this.scrollPressed(false);
            }
        } else if (this.func_146978_c(136, 4, 82, 11, mouseX, mouseY)) {
            if (Mouse.getEventButtonState()) {
                this.searchField.func_146195_b(true);
            }
        } else if (this.func_146978_c(0, 14, this.field_146294_l, 200, mouseX, mouseY) && Mouse.getEventButtonState()) {
            this.searchField.func_146195_b(false);
        }
    }

    public void scrollPressed(boolean up) {
        if (up && this.upB.field_146124_l) {
            this.sendToServer(this.upB.field_146127_k);
        } else if (!up && this.downB.field_146124_l) {
            this.sendToServer(this.downB.field_146127_k);
        }
    }
}

