/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.railroad;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.entity.EntitySteamLocomotive;
import cassiokf.industrialrenewal.util.enums.enumproperty.EnumSnowRail;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockNormalRailBase
extends BlockRail {
    public static final IProperty<EnumSnowRail> SNOW = PropertyEnum.func_177709_a((String)"snow", EnumSnowRail.class);
    protected String name;

    public BlockNormalRailBase(String name, CreativeTabs tab) {
        this.name = name;
        this.setRegistryName("industrialrenewal", name);
        this.func_149663_c("industrialrenewal." + name);
        this.func_149711_c(1.0f);
        this.func_149752_b(15.0f);
        this.func_149647_a(tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SNOW, (Comparable)((Object)EnumSnowRail.FALSE)));
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        if (world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos).func_177229_b(SNOW) == EnumSnowRail.LAYER2 && this.isCartRunning(cart)) {
            boolean plow;
            this.spawnSnowParticle(world, cart.field_70165_t, cart.field_70163_u, cart.field_70161_v);
            if (cart instanceof EntitySteamLocomotive && !world.field_72995_K && (plow = ((EntitySteamLocomotive)cart).hasPlowItem)) {
                this.plowSnow(world, pos);
            }
        }
    }

    private void spawnSnowParticle(World world, double x, double y, double z) {
        float f = MathHelper.func_76123_f((float)1.0f);
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(150.0 * d0);
        ((WorldServer)world).func_175739_a(EnumParticleTypes.BLOCK_DUST, x, y, z, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150433_aE.func_176223_P())});
    }

    private void plowSnow(World world, BlockPos pos) {
        BlockPos neighbor2;
        BlockPos neighbor1;
        IBlockState state = world.func_180495_p(pos);
        switch ((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176565_b)) {
            default: {
                neighbor1 = pos.func_177972_a(EnumFacing.WEST);
                neighbor2 = pos.func_177972_a(EnumFacing.EAST);
                break;
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case SOUTH_EAST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.WEST);
                break;
            }
            case NORTH_EAST: {
                neighbor1 = pos.func_177972_a(EnumFacing.WEST);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case NORTH_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.EAST);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case SOUTH_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.EAST);
            }
        }
        IBlockState state1 = world.func_180495_p(neighbor1);
        IBlockState state2 = world.func_180495_p(neighbor2);
        Block n1 = state1.func_177230_c();
        Block n2 = state2.func_177230_c();
        if (n1 instanceof BlockSnow && (Integer)state1.func_177229_b((IProperty)BlockSnow.field_176315_a) > 1) {
            this.spawnSnowParticle(world, neighbor1.func_177958_n(), neighbor1.func_177956_o(), neighbor1.func_177952_p());
            world.func_175656_a(neighbor1, state1.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1)));
        }
        if (n2 instanceof BlockSnow && (Integer)state2.func_177229_b((IProperty)BlockSnow.field_176315_a) > 1) {
            this.spawnSnowParticle(world, neighbor2.func_177958_n(), neighbor2.func_177956_o(), neighbor2.func_177952_p());
            world.func_175656_a(neighbor2, state2.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1)));
        }
    }

    private EnumSnowRail checkSnow(IBlockAccess world, BlockPos pos, IBlockState state) {
        BlockPos neighbor2;
        BlockPos neighbor1;
        switch ((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176565_b)) {
            default: {
                neighbor1 = pos.func_177972_a(EnumFacing.WEST);
                neighbor2 = pos.func_177972_a(EnumFacing.EAST);
                break;
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case EAST_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case SOUTH_EAST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.WEST);
                break;
            }
            case NORTH_EAST: {
                neighbor1 = pos.func_177972_a(EnumFacing.WEST);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case NORTH_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.EAST);
                neighbor2 = pos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case SOUTH_WEST: {
                neighbor1 = pos.func_177972_a(EnumFacing.NORTH);
                neighbor2 = pos.func_177972_a(EnumFacing.EAST);
            }
        }
        IBlockState state1 = world.func_180495_p(neighbor1);
        IBlockState state2 = world.func_180495_p(neighbor2);
        Block n1 = state1.func_177230_c();
        Block n2 = state2.func_177230_c();
        if (n1 instanceof BlockSnow || n2 instanceof BlockSnow) {
            if (n1 instanceof BlockSnow && (Integer)state1.func_177229_b((IProperty)BlockSnow.field_176315_a) >= 2 || n2 instanceof BlockSnow && (Integer)state2.func_177229_b((IProperty)BlockSnow.field_176315_a) >= 2) {
                return EnumSnowRail.LAYER2;
            }
            if (n1 instanceof BlockSnow && (Integer)state1.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1 || n2 instanceof BlockSnow && (Integer)state2.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1) {
                return EnumSnowRail.LAYER1;
            }
            return EnumSnowRail.FALSE;
        }
        return EnumSnowRail.FALSE;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(SNOW, (Comparable)((Object)this.checkSnow(world, pos, state)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176565_b, SNOW});
    }

    private boolean isCartRunning(EntityMinecart cart) {
        Double speed = Math.max(Math.abs(cart.field_70159_w), Math.abs(cart.field_70179_y));
        return speed > 0.01;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void registerItemModel(Item itemBlock) {
        IndustrialRenewal.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        if (world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos).func_177229_b(SNOW) == EnumSnowRail.LAYER2) {
            return 0.2f;
        }
        return 0.4f;
    }
}

