/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.BlockPillar;
import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockPillarFluidPipe;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.util.enums.EnumEnergyCableType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockPillarEnergyCable
extends BlockEnergyCable {
    private static final float DOWNY1 = 0.0f;
    private static final float UPY2 = 1.0f;
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;

    public BlockPillarEnergyCable(EnumEnergyCableType type, String name, CreativeTabs tab) {
        super(type, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{MASTER, SOUTH, NORTH, EAST, WEST, UP, DOWN, CSOUTH, CNORTH, CEAST, CWEST, CUP, CDOWN, WSOUTH, WNORTH, WEAST, WWEST, WUP, WDOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        BlockEnergyCable block;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (this.type) {
            default: {
                block = ModBlocks.energyCableLV;
                break;
            }
            case MV: {
                block = ModBlocks.energyCableMV;
                break;
            }
            case HV: {
                block = ModBlocks.energyCableHV;
            }
        }
        ItemStack itemst = new ItemStack(ItemBlock.func_150898_a((Block)block));
        EntityItem entity = new EntityItem(worldIn, (double)x, (double)y, (double)z, itemst);
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)entity);
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.pillar));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
        Item playerItem = playerStack.func_77973_b();
        if (playerItem instanceof ItemPowerScrewDrive) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, ModBlocks.pillar.func_176223_P(), 3);
                if (!player.func_184812_l_()) {
                    BlockEnergyCable block;
                    switch (this.type) {
                        default: {
                            block = ModBlocks.energyCableLV;
                            break;
                        }
                        case MV: {
                            block = ModBlocks.energyCableMV;
                            break;
                        }
                        case HV: {
                            block = ModBlocks.energyCableHV;
                        }
                    }
                    player.func_191521_c(new ItemStack(Item.func_150898_a((Block)block)));
                }
                ItemPowerScrewDrive.playDrillSound(world, pos);
            }
            return true;
        }
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.pillar))) {
            int n = 1;
            while (world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillarEnergyCable || world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillarFluidPipe || world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillar) {
                ++n;
            }
            if (world.func_180495_p(pos.func_177981_b(n)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177981_b(n))) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos.func_177981_b(n), Block.func_149634_a((Item)playerItem).func_176223_P(), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        playerStack.func_190918_g(1);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            return eState.withProperty(MASTER, (Object)this.isMaster(world, pos)).withProperty(SOUTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.SOUTH)).withProperty(NORTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.NORTH)).withProperty(EAST, (Object)this.canConnectToPipe(world, pos, EnumFacing.EAST)).withProperty(WEST, (Object)this.canConnectToPipe(world, pos, EnumFacing.WEST)).withProperty(UP, (Object)this.canConnectToPipe(world, pos, EnumFacing.UP)).withProperty(DOWN, (Object)this.canConnectToPipe(world, pos, EnumFacing.DOWN)).withProperty(CSOUTH, (Object)this.canConnectToCapability(world, pos, EnumFacing.SOUTH)).withProperty(CNORTH, (Object)this.canConnectToCapability(world, pos, EnumFacing.NORTH)).withProperty(CEAST, (Object)this.canConnectToCapability(world, pos, EnumFacing.EAST)).withProperty(CWEST, (Object)this.canConnectToCapability(world, pos, EnumFacing.WEST)).withProperty(CUP, (Object)this.canConnectToCapability(world, pos, EnumFacing.UP)).withProperty(CDOWN, (Object)this.canConnectToCapability(world, pos, EnumFacing.DOWN)).withProperty(WSOUTH, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.SOUTH)).withProperty(WNORTH, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.NORTH)).withProperty(WEAST, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.EAST)).withProperty(WWEST, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.WEST)).withProperty(WUP, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.UP)).withProperty(WDOWN, (Object)BlockPillar.canConnectTo(world, pos, EnumFacing.DOWN));
        }
        return state;
    }

    public final boolean isConnected(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (state instanceof IExtendedBlockState) {
            state = this.getExtendedState(state, world, pos);
            IExtendedBlockState eState = (IExtendedBlockState)state;
            switch (facing) {
                case DOWN: {
                    return (Boolean)eState.getValue(WDOWN);
                }
                case UP: {
                    return (Boolean)eState.getValue(WUP);
                }
                case NORTH: {
                    return (Boolean)eState.getValue(WNORTH);
                }
                case SOUTH: {
                    return (Boolean)eState.getValue(WSOUTH);
                }
                case WEST: {
                    return (Boolean)eState.getValue(WWEST);
                }
                case EAST: {
                    return (Boolean)eState.getValue(WEAST);
                }
            }
        }
        return false;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.isConnected(worldIn, pos, state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(worldIn, pos, state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected(worldIn, pos, state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(worldIn, pos, state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected(worldIn, pos, state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(worldIn, pos, state, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected(worldIn, pos, state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(worldIn, pos, state, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        return new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.EAST || face == EnumFacing.WEST || face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

