/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableGauge;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableHVGauge;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableLVGauge;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableMVGauge;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.enums.EnumEnergyCableType;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockEnergyCableGauge
extends BlockEnergyCable {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockEnergyCableGauge(EnumEnergyCableType type, String name, CreativeTabs tab) {
        super(type, name, tab);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{MASTER, SOUTH, NORTH, EAST, WEST, UP, DOWN, CSOUTH, CNORTH, CEAST, CWEST, CUP, CDOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            IExtendedBlockState eState = (IExtendedBlockState)state;
            return eState.withProperty(MASTER, (Object)this.isMaster(world, pos)).withProperty(SOUTH, (Object)this.canConnectToPipe(world, pos, facing.func_176734_d())).withProperty(NORTH, (Object)this.canConnectToPipe(world, pos, facing)).withProperty(EAST, (Object)this.canConnectToPipe(world, pos, facing.func_176746_e())).withProperty(WEST, (Object)this.canConnectToPipe(world, pos, facing.func_176735_f())).withProperty(UP, (Object)this.canConnectToPipe(world, pos, EnumFacing.UP)).withProperty(DOWN, (Object)this.canConnectToPipe(world, pos, EnumFacing.DOWN)).withProperty(CSOUTH, (Object)this.canConnectToCapability(world, pos, facing.func_176734_d())).withProperty(CNORTH, (Object)this.canConnectToCapability(world, pos, facing)).withProperty(CEAST, (Object)this.canConnectToCapability(world, pos, facing.func_176746_e())).withProperty(CWEST, (Object)this.canConnectToCapability(world, pos, facing.func_176735_f())).withProperty(CUP, (Object)this.canConnectToCapability(world, pos, EnumFacing.UP)).withProperty(CDOWN, (Object)this.canConnectToCapability(world, pos, EnumFacing.DOWN));
        }
        return state;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entity.func_184614_ca().func_77973_b() instanceof ItemPowerScrewDrive && !world.field_72995_K) {
            BlockEnergyCable block;
            switch (this.type) {
                default: {
                    block = ModBlocks.energyCableLV;
                    break;
                }
                case MV: {
                    block = ModBlocks.energyCableMV;
                    break;
                }
                case HV: {
                    block = ModBlocks.energyCableHV;
                }
            }
            world.func_180501_a(pos, block.func_176223_P(), 3);
            if (!entity.func_184812_l_()) {
                entity.func_191521_c(new ItemStack(Item.func_150898_a((Block)ModBlocks.energyLevel)));
            }
            ItemPowerScrewDrive.playDrillSound(world, pos);
        }
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        BlockEnergyCable block;
        switch (this.type) {
            default: {
                block = ModBlocks.energyCableLV;
                break;
            }
            case MV: {
                block = ModBlocks.energyCableMV;
                break;
            }
            case HV: {
                block = ModBlocks.energyCableHV;
            }
        }
        return new ItemStack(Item.func_150898_a((Block)block));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            ItemStack itemst = new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.energyLevel));
            Utils.spawnItemStack(world, pos, itemst);
            Utils.spawnItemStack(world, pos, this.func_185473_a(world, pos, state));
        }
        super.func_176206_d(world, pos, state);
    }

    @Override
    @Nullable
    public TileEntityEnergyCableGauge createTileEntity(World world, IBlockState state) {
        switch (this.type) {
            default: {
                return new TileEntityEnergyCableLVGauge();
            }
            case MV: {
                return new TileEntityEnergyCableMVGauge();
            }
            case HV: 
        }
        return new TileEntityEnergyCableHVGauge();
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        switch (this.type) {
            default: {
                return new TileEntityEnergyCableLVGauge();
            }
            case MV: {
                return new TileEntityEnergyCableMVGauge();
            }
            case HV: 
        }
        return new TileEntityEnergyCableHVGauge();
    }
}

